/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.api.energy.ISonarEnergyContainerHandler;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.common.block.SonarBlockTip;
import sonar.flux.FluxConfig;
import sonar.flux.FluxCrafting;
import sonar.flux.FluxEvents;
import sonar.flux.api.FluxAPI;
import sonar.flux.common.block.FluxController;
import sonar.flux.common.block.FluxPlug;
import sonar.flux.common.block.FluxPoint;
import sonar.flux.common.block.FluxStorage;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.common.item.FluxConfigurator;
import sonar.flux.common.item.FluxItem;
import sonar.flux.common.tileentity.TileEntityController;
import sonar.flux.common.tileentity.TileEntityPlug;
import sonar.flux.common.tileentity.TileEntityPoint;
import sonar.flux.common.tileentity.TileEntityStorage;
import sonar.flux.connection.FluxHelper;
import sonar.flux.network.ClientNetworkCache;
import sonar.flux.network.FluxCommon;
import sonar.flux.network.FluxNetworkCache;

@Mod(modid="fluxnetworks", name="FluxNetworks", version="1.2.5", dependencies="required-after:sonarcore@[3.2.7,);", acceptedMinecraftVersions="[1.10.2]")
public class FluxNetworks {
    public static final String modid = "fluxnetworks";
    public static final String version = "1.2.5";
    public static final String SONAR_VERSION = "3.2.7";
    public static final int saveDimension = 0;
    @SidedProxy(clientSide="sonar.flux.network.FluxClient", serverSide="sonar.flux.network.FluxCommon")
    public static FluxCommon proxy;
    @Mod.Instance(value="fluxnetworks")
    public static FluxNetworks instance;
    public FluxNetworkCache serverCache = new FluxNetworkCache();
    public ClientNetworkCache clientCache = new ClientNetworkCache();
    public static List<ISonarEnergyHandler> energyHandlers;
    public static List<ISonarEnergyContainerHandler> energyContainerHandlers;
    public static SimpleNetworkWrapper network;
    public static Logger logger;
    public static Item flux;
    public static Item fluxCore;
    public static Item fluxConfigurator;
    public static Block fluxBlock;
    public static Block fluxPlug;
    public static Block fluxPoint;
    public static Block fluxCable;
    public static Block fluxStorage;
    public static Block largeFluxStorage;
    public static Block massiveFluxStorage;
    public static Block fluxController;
    public static ArrayList<Item> registeredItems;
    public static ArrayList<Block> registeredBlocks;
    public static CreativeTabs tab;

    public static Block registerBlock(String name, Block block) {
        block.func_149647_a(tab);
        GameRegistry.registerBlock((Block)block.func_149663_c(name), SonarBlockTip.class, (String)name);
        registeredBlocks.add(block);
        return block;
    }

    public static Item registerItem(String name, Item item) {
        item.func_77637_a(tab);
        GameRegistry.registerItem((Item)item.func_77655_b(name), (String)name);
        registeredItems.add(item);
        return item;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Initilising API");
        FluxAPI.init();
        logger.info("Loading Config");
        FluxConfig.startLoading();
        logger.info("Loading Network");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Flux-Networks");
        logger.info("Loading Blocks/Items");
        fluxBlock = FluxNetworks.registerBlock("FluxBlock", new Block(Material.field_151576_e));
        flux = FluxNetworks.registerItem("Flux", new FluxItem());
        fluxCore = FluxNetworks.registerItem("FluxCore", new Item());
        fluxConfigurator = FluxNetworks.registerItem("FluxConfigurator", (Item)new FluxConfigurator());
        fluxPlug = FluxNetworks.registerBlock("FluxPlug", new FluxPlug().func_149711_c(0.4f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityPlug.class, (String)"FluxPlug");
        fluxPoint = FluxNetworks.registerBlock("FluxPoint", new FluxPoint().func_149711_c(0.2f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityPoint.class, (String)"FluxPoint");
        fluxController = FluxNetworks.registerBlock("FluxController", new FluxController().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityController.class, (String)"FluxController");
        fluxStorage = FluxNetworks.registerBlock("FluxStorage", new FluxStorage().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Basic.class, (String)"FluxStorage");
        largeFluxStorage = FluxNetworks.registerBlock("HerculeanFluxStorage", new FluxStorage.Herculean().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Advanced.class, (String)"HerculeanFluxStorage");
        massiveFluxStorage = FluxNetworks.registerBlock("GargantuanFluxStorage", new FluxStorage.Gargantuan().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Massive.class, (String)"GargantuanFluxStorage");
        logger.info("Loading Entities");
        EntityRegistry.registerModEntity(EntityFireItem.class, (String)"Flux", (int)0, (Object)instance, (int)64, (int)10, (boolean)true);
        logger.info("Loading Recipes");
        FluxCrafting.addRecipes();
        logger.info("Loading Packets");
        proxy.registerPackets();
        logger.info("Loading Renderers");
        proxy.registerRenderThings();
        logger.info("Finished Pre-Initialization");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Loading Handlers");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new FluxCommon());
        logger.info("Loaded Handlers");
        logger.info("Loading Handlers");
        MinecraftForge.EVENT_BUS.register((Object)new FluxEvents());
        logger.info("Loaded Events");
        logger.info("Finished Initialization");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FluxConfig.finishLoading();
        energyHandlers = FluxHelper.getEnergyHandlers();
        energyContainerHandlers = FluxHelper.getEnergyContainerHandlers();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppedEvent event) {
        this.serverCache.clearNetworks();
        logger.info("Removed Networks");
    }

    public static ClientNetworkCache getClientCache() {
        return FluxNetworks.instance.clientCache;
    }

    public static FluxNetworkCache getServerCache() {
        return FluxNetworks.instance.serverCache;
    }

    static {
        logger = LogManager.getLogger((String)modid);
        registeredItems = Lists.newArrayList();
        registeredBlocks = Lists.newArrayList();
        tab = new CreativeTabs("Flux Networks"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)fluxPlug);
            }
        };
    }
}

