/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import sonar.core.common.block.SonarBlockTip;
import sonar.flux.FluxNetworks;

public class FluxCrafting
extends FluxNetworks {
    public static void addRecipes() {
        RecipeSorter.register((String)"fluxNetworks:storage", StorageCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        FluxCrafting.addShaped(new ItemStack(fluxConfigurator, 1), " CP", " OC", "O  ", Character.valueOf('C'), fluxCore, Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('O'), Blocks.field_150343_Z);
        FluxCrafting.addShaped(new ItemStack(fluxBlock, 1), "ACA", "CAC", "ACA", Character.valueOf('A'), flux, Character.valueOf('C'), fluxCore);
        FluxCrafting.addShaped(new ItemStack(fluxCore, 4), "GCG", "CAC", "GCG", Character.valueOf('C'), Blocks.field_150343_Z, Character.valueOf('G'), flux, Character.valueOf('A'), Items.field_151061_bv);
        FluxCrafting.addShaped(new ItemStack(fluxController, 1), "BCB", "R R", "BBB", Character.valueOf('C'), fluxCore, Character.valueOf('B'), fluxBlock, Character.valueOf('R'), flux);
        FluxCrafting.addShaped(new ItemStack(fluxPlug, 1), " C ", "CBC", " C ", Character.valueOf('C'), fluxCore, Character.valueOf('B'), fluxBlock);
        FluxCrafting.addShaped(new ItemStack(fluxPoint, 1), " C ", "CBC", " C ", Character.valueOf('C'), fluxCore, Character.valueOf('B'), Blocks.field_150451_bX);
        FluxCrafting.addStorageRecipe(new ItemStack(fluxStorage, 1), "BBB", "G G", "BBB", Character.valueOf('B'), fluxBlock, Character.valueOf('G'), "paneGlassColorless");
        FluxCrafting.addStorageRecipe(new ItemStack(largeFluxStorage, 1), "BBB", "G G", "BBB", Character.valueOf('B'), fluxStorage, Character.valueOf('G'), "paneGlassColorless");
        FluxCrafting.addStorageRecipe(new ItemStack(massiveFluxStorage, 1), "BBB", "G G", "BBB", Character.valueOf('B'), largeFluxStorage, Character.valueOf('G'), "paneGlassColorless");
    }

    public static void addShaped(ItemStack result, Object ... input) {
        if (result != null && result.func_77973_b() != null && input != null) {
            try {
                GameRegistry.addRecipe((ItemStack)result, (Object[])input);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPED RECIPE: " + result);
            }
        }
    }

    public static void addStorageRecipe(ItemStack result, Object ... input) {
        if (result != null && result.func_77973_b() != null && input != null) {
            try {
                StorageCrafting oreRecipe = new StorageCrafting(result, input);
                GameRegistry.addRecipe((IRecipe)oreRecipe);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING FLUX STORAGE RECIPE: " + result);
            }
        }
    }

    public static void addShapedOre(ItemStack result, Object ... input) {
        if (result != null && result.func_77973_b() != null && input != null) {
            try {
                ShapedOreRecipe oreRecipe = new ShapedOreRecipe(result, input);
                GameRegistry.addRecipe((IRecipe)oreRecipe);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPED ORE RECIPE: " + result);
            }
        }
    }

    public static void addShapeless(ItemStack result, Object ... input) {
        if (result != null && result.func_77973_b() != null && input != null) {
            try {
                GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])input);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPELESS RECIPE: " + result);
            }
        }
    }

    public static class StorageCrafting
    extends ShapedOreRecipe {
        public StorageCrafting(Block result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public StorageCrafting(Item result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public StorageCrafting(ItemStack result, Object ... recipe) {
            super(result, recipe);
        }

        public ItemStack func_77572_b(InventoryCrafting crafting) {
            int energyStored = 0;
            for (int i = 0; i < crafting.func_70302_i_(); ++i) {
                ItemStack stack = crafting.func_70301_a(i);
                if (stack == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof SonarBlockTip)) continue;
                NBTTagCompound tag = stack.func_77978_p();
                energyStored += tag.func_74762_e("energy");
            }
            ItemStack stack = this.output.func_77946_l();
            if (this.output != null) {
                NBTTagCompound newTag = stack.func_77978_p();
                if (newTag == null) {
                    newTag = new NBTTagCompound();
                }
                newTag.func_74768_a("energy", energyStored);
                stack.func_77982_d(newTag);
            }
            return stack;
        }
    }
}

