/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import sonar.core.SonarCore;
import sonar.core.api.energy.EnergyType;
import sonar.core.utils.Pair;
import sonar.flux.FluxNetworks;

public class FluxConfig
extends FluxNetworks {
    public static long defaultLimit;
    public static boolean banHyper;
    public static boolean banGod;
    public static int basicCapacity;
    public static int herculeanCapacity;
    public static int gargantuanCapacity;
    public static int basicTransfer;
    public static int herculeanTransfer;
    public static int gargantuanTransfer;
    public static int hyper;
    public static int god;
    public static Map<EnergyType, Pair<Boolean, Boolean>> transfers;
    public static Configuration config;

    public static void startLoading() {
        config = new Configuration(new File("config/flux_networks.cfg"));
        config.load();
        defaultLimit = (long)config.getFloat("Default Transfer Limit", "energy", 256000.0f, 0.0f, 9.223372E18f, "the default transfer limit of a flux connection");
        basicCapacity = config.getInt("Basic Storage Capacity", "energy", 256000, 0, Integer.MAX_VALUE, "");
        basicTransfer = config.getInt("Basic Storage Transfer", "energy", 6400, 0, Integer.MAX_VALUE, "");
        herculeanCapacity = config.getInt("Herculean Storage Capacity", "energy", 12800000, 0, Integer.MAX_VALUE, "");
        herculeanTransfer = config.getInt("Herculean Storage Transfer", "energy", 12800, 0, Integer.MAX_VALUE, "");
        gargantuanCapacity = config.getInt("Gargantuan Storage Capacity", "energy", 128000000, 0, Integer.MAX_VALUE, "");
        gargantuanTransfer = config.getInt("Gargantuan Storage Transfer", "energy", 256000, 0, Integer.MAX_VALUE, "");
        hyper = config.getInt("Hyper Mode Multiplier", "energy", 4, 1, 16, "the multiplier for hyper mode - for how much energy is transfer compared to normal rate");
        god = config.getInt("God Mode Multiplier", "energy", 10, 1, 16, "the multiplier god mod - for how much energy is transfer compared to normal rate");
        banHyper = config.getBoolean("Ban Hyper Mode", "settings", false, "prevents the use of Hyper Mode");
        banGod = config.getBoolean("Ban God Mode", "settings", false, "prevents the use of God Mode");
        config.save();
    }

    public static void finishLoading() {
        for (EnergyType type : SonarCore.energyTypes.getObjects()) {
            boolean block = FluxConfig.getEnergyTypeBoolean(type.getName() + " Transfer: Blocks", "energy types", true);
            boolean item = FluxConfig.getEnergyTypeBoolean(type.getName() + " Transfer: Items", "energy types", true);
            transfers.put(type, (Pair<Boolean, Boolean>)new Pair((Object)item, (Object)block));
        }
        config.save();
    }

    public static boolean getEnergyTypeBoolean(String name, String category, boolean defaultValue) {
        Property prop = config.get(category, name, defaultValue);
        prop.setLanguageKey(name);
        return prop.getBoolean(defaultValue);
    }

    static {
        hyper = 4;
        god = 10;
        transfers = Maps.newHashMap();
    }
}

