/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.util.handler;

import WayofTime.bloodmagic.util.Utils;
import arc.bloodarsenal.modifier.IModifiableItem;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.modifier.modifiers.ModifierBloodlust;
import arc.bloodarsenal.modifier.modifiers.ModifierFlame;
import arc.bloodarsenal.modifier.modifiers.ModifierLooting;
import arc.bloodarsenal.modifier.modifiers.ModifierSharpness;
import arc.bloodarsenal.modifier.modifiers.ModifierXP;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TrackerHandler {
    private static Random rand = new Random();

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack modifiableStack;
        DamageSource source = event.getSource();
        Entity sourceEntity = source.func_76346_g();
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (attackedEntity.func_94060_bK() instanceof EntityPlayer && (modifiableStack = (player = (EntityPlayer)attackedEntity.func_94060_bK()).func_184614_ca()) != null && modifiableStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getStasisModifiable(modifiableStack)) != null) {
            float amount = Math.min(Utils.getModifiedDamage((EntityLivingBase)attackedEntity, (DamageSource)event.getSource(), (float)event.getAmount()), attackedEntity.func_110143_aJ());
            if (modifiable.hasModifier(ModifierFlame.class) && source.func_76347_k()) {
                ModifierTracker.incrementCounter(modifiable, ModifierFlame.class, amount);
            }
            float reducedAmount = amount / 4.0f;
            if (modifiable.hasModifier(ModifierBloodlust.class)) {
                ModifierTracker.incrementCounter(modifiable, ModifierBloodlust.class, reducedAmount);
            } else if (modifiable.hasModifier(ModifierSharpness.class)) {
                ModifierTracker.incrementCounter(modifiable, ModifierSharpness.class, reducedAmount);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack modifiableStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (event.getLootingLevel() >= 1 && attackedEntity.func_94060_bK() instanceof EntityPlayer && (modifiableStack = (player = (EntityPlayer)attackedEntity.func_94060_bK()).func_184614_ca()) != null && modifiableStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getStasisModifiable(modifiableStack)) != null && modifiable.hasModifier(ModifierLooting.class)) {
            ModifierTracker.incrementCounter(modifiable, ModifierLooting.class, 1.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingXPDrop(LivingExperienceDropEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getAttackingPlayer() != null && (itemStack = (player = event.getAttackingPlayer()).func_184614_ca()) != null && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getStasisModifiable(itemStack)) != null && modifiable.hasModifier(ModifierXP.class)) {
            ModifierXP modifier = (ModifierXP)modifiable.getModifier(ModifierXP.class);
            event.setDroppedExperience(event.getOriginalExperience() * (rand.nextInt(modifier.getLevel() + 2) + 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onXPPickup(PlayerPickupXpEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getEntityPlayer() != null && (itemStack = (player = event.getEntityPlayer()).func_184614_ca()) != null && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getStasisModifiable(itemStack)) != null && modifiable.hasModifier(ModifierXP.class)) {
            ModifierTracker.incrementCounter(modifiable, ModifierXP.class, event.getOrb().func_70526_d());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getPlayer() != null && (itemStack = (player = event.getPlayer()).func_184614_ca()) != null && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getStasisModifiable(itemStack)) != null && modifiable.hasModifier(ModifierXP.class) && event.getExpToDrop() > 0) {
            ModifierXP modifier = (ModifierXP)modifiable.getModifier(ModifierXP.class);
            event.setExpToDrop(event.getExpToDrop() * (rand.nextInt(modifier.getLevel() + 2) + 1));
        }
    }
}

