/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.util;

import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.impl.ItemSigilToggleable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.item.IProfilable;
import arc.bloodarsenal.registry.Constants;
import arc.bloodarsenal.tile.TileInventory;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BloodArsenalUtils {
    public static boolean insertItemIntoTile(EntityPlayer player, TileInventory tile) {
        return BloodArsenalUtils.insertItemIntoTile(player, 1, tile, 0);
    }

    public static boolean insertItemIntoTile(EntityPlayer player, int amount, TileInventory tile) {
        return BloodArsenalUtils.insertItemIntoTile(player, amount, tile, 0);
    }

    public static boolean insertItemIntoTile(EntityPlayer player, int amount, TileInventory tile, int slot) {
        if (tile.func_70301_a(slot) == null && player.func_184614_ca() != null) {
            ItemStack input = player.func_184614_ca().func_77946_l();
            input.field_77994_a = amount;
            player.func_184614_ca().field_77994_a -= amount;
            tile.func_70299_a(slot, input);
            return true;
        }
        if (tile.func_70301_a(slot) != null && player.func_184614_ca() == null) {
            if (!tile.func_145831_w().field_72995_K) {
                EntityItem invItem = new EntityItem(tile.func_145831_w(), player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, tile.func_70301_a(slot));
                tile.func_145831_w().func_72838_d((Entity)invItem);
            }
            tile.func_174888_l();
            return false;
        }
        return false;
    }

    public static RayTraceResult rayTrace(World world, EntityPlayer player, boolean useLiquids) {
        if (world == null || player == null) {
            return null;
        }
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double range = ConfigHandler.rayTraceRange;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return world.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static boolean isSigilInInvAndActive(EntityPlayer player, Item item) {
        if (item instanceof ItemSigilToggleable) {
            for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
                if (itemStack == null || itemStack.func_77973_b() != item) continue;
                return ((ItemSigilToggleable)itemStack.func_77973_b()).getActivated(itemStack);
            }
        }
        return false;
    }

    public static boolean canItemBreakBlock(EntityPlayer player, ItemStack itemStack, IBlockState blockState) {
        if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_177230_c() != Blocks.field_150357_h && blockState.func_177230_c() != Blocks.field_180401_cv) {
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemSword) {
                return item.func_150893_a(itemStack, blockState) > 1.0f || item.func_150897_b(blockState);
            }
            String toolClass = BloodArsenalUtils.getToolType(item);
            return toolClass.equals(blockState.func_177230_c().getHarvestTool(blockState)) && item.getHarvestLevel(itemStack, toolClass, player, blockState) >= blockState.func_177230_c().getHarvestLevel(blockState) || item.func_150893_a(itemStack, blockState) > 1.0f && item.func_150897_b(blockState);
        }
        return false;
    }

    public static String getToolType(Item tool) {
        String toolClass = "";
        if (tool instanceof ItemPickaxe) {
            toolClass = "pickaxe";
        } else if (tool instanceof ItemAxe) {
            toolClass = "axe";
        } else if (tool instanceof ItemSpade) {
            toolClass = "shovel";
        }
        return toolClass;
    }

    public static List<BlockPos> getBlocksInRegion(World world, BlockPos pos, AxisAlignedBB bb) {
        return BloodArsenalUtils.getBlocksInRegion(world, pos, bb, Blocks.field_150350_a);
    }

    public static List<BlockPos> getBlocksInRegion(World world, BlockPos pos, AxisAlignedBB bb, Block checkBlock) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        if (world.func_180495_p(pos) != Blocks.field_150350_a) {
            bb = bb.func_186670_a(pos);
            int i = (int)bb.field_72340_a;
            while ((double)i < bb.field_72336_d) {
                int j = (int)bb.field_72338_b;
                while ((double)j < bb.field_72337_e) {
                    int k = (int)bb.field_72339_c;
                    while ((double)k < bb.field_72334_f) {
                        BlockPos checkPos = new BlockPos(i, j, k);
                        if (world.func_180495_p(checkPos) != Blocks.field_150350_a && (checkBlock == Blocks.field_150350_a || world.func_180495_p(checkPos).func_177230_c() == checkBlock)) {
                            blocks.add(checkPos);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return blocks;
    }

    public static void dropStacks(Multiset<ItemStackWrapper> drops, World world, BlockPos posToDrop) {
        for (Multiset.Entry entry : drops.entrySet()) {
            int count;
            ItemStackWrapper stack = (ItemStackWrapper)entry.getElement();
            int maxStackSize = stack.item.getItemStackLimit(stack.toStack(1));
            for (count = entry.getCount(); count >= maxStackSize; count -= maxStackSize) {
                world.func_72838_d((Entity)new EntityItem(world, (double)posToDrop.func_177958_n(), (double)posToDrop.func_177956_o(), (double)posToDrop.func_177952_p(), stack.toStack(maxStackSize)));
            }
            if (count <= 0) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)posToDrop.func_177958_n(), (double)posToDrop.func_177956_o(), (double)posToDrop.func_177952_p(), stack.toStack(count)));
        }
    }

    public static void tillBlock(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state, 11);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    public static boolean hasFullSet(EntityPlayer player, Class<? extends ItemArmor> armor) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack itemStack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (itemStack = player.func_184582_a(slot)) != null && itemStack.func_77973_b().getClass().isInstance(armor)) continue;
            return false;
        }
        return true;
    }

    public static Set<Block> getEffectiveBlocksForTool(String name) {
        switch (name) {
            case "axe": {
                return Constants.Item.AXE_EFFECTIVE_ON;
            }
            case "pickaxe": {
                return Constants.Item.PICKAXE_EFFECTIVE_ON;
            }
            case "shovel": {
                return Constants.Item.SHOVEL_EFFECTIVE_ON;
            }
            case "sickle": {
                return Constants.Item.SICKLE_EFFECTIVE_ON;
            }
        }
        return Sets.newHashSet();
    }

    public static Set<Material> getEffectiveMaterialsForTool(String name) {
        switch (name) {
            case "axe": {
                return Constants.Item.AXE_MATERIALS_EFFECTIVE_ON;
            }
            case "pickaxe": {
                return Constants.Item.PICKAXE_MATERIALS_EFFECTIVE_ON;
            }
            case "shovel": {
                return Constants.Item.SHOVEL_MATERIALS_EFFECTIVE_ON;
            }
            case "sickle": {
                return Constants.Item.SICKLE_MAERIALS_EFFECTIVE_ON;
            }
        }
        return Sets.newHashSet();
    }

    public static void writeNBTEnchantment(ItemStack itemStack, Enchantment enchantment, int level) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagList enchantments = tag.func_150295_c("ench", 10);
        if (enchantments == null) {
            enchantments = new NBTTagList();
        }
        NBTTagCompound enchTag = new NBTTagCompound();
        enchTag.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)enchantment));
        enchTag.func_74777_a("lvl", (short)level);
        enchantments.func_74742_a((NBTBase)enchTag);
        tag.func_74782_a("ench", (NBTBase)enchantments);
    }

    public static void removeNBTEnchantment(ItemStack itemStack, Enchantment enchantment) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagList enchantments = itemStack.func_77986_q();
        if (enchantments == null) {
            return;
        }
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            NBTTagCompound compound = enchantments.func_150305_b(i);
            short id = compound.func_74765_d("id");
            if (id != Enchantment.func_185258_b((Enchantment)enchantment)) continue;
            enchantments.func_74744_a(i);
        }
        if (enchantments.func_74745_c() == 0) {
            tag.func_82580_o("ench");
        }
    }

    public static boolean areStacksEqual(Object oreStack, ItemStack compare) {
        if (oreStack instanceof String) {
            int[] ids;
            if (!OreDictionary.doesOreNameExist((String)((String)oreStack))) {
                return false;
            }
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)compare)) {
                if (!OreDictionary.getOreName((int)id).equals(oreStack)) continue;
                return true;
            }
        } else {
            if (oreStack instanceof ItemStack) {
                return OreDictionary.itemMatches((ItemStack)compare, (ItemStack)((ItemStack)oreStack), (boolean)false);
            }
            if (oreStack instanceof Item) {
                return BloodArsenalUtils.areStacksEqual(new ItemStack((Item)oreStack), compare);
            }
            if (oreStack instanceof Block) {
                return BloodArsenalUtils.areStacksEqual(new ItemStack((Block)oreStack), compare);
            }
        }
        return false;
    }

    public static ItemStack findFirstOreMatch(String oreName) {
        if (!OreDictionary.doesOreNameExist((String)oreName)) {
            return null;
        }
        List stacks = OreDictionary.getOres((String)oreName);
        if (stacks.size() == 0) {
            return null;
        }
        return (ItemStack)stacks.get(0);
    }

    public static ItemStack resolveObject(Object obj) {
        if (obj instanceof String) {
            return BloodArsenalUtils.findFirstOreMatch((String)obj);
        }
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        return null;
    }

    public static int next(int mode, int max) {
        int index = mode + 1;
        if (index >= max) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode, int max) {
        int index = mode - 1;
        if (index < 0) {
            index = max;
        }
        return index;
    }

    public static class Profilable {
        public static IProfilable getProfilable(ItemStack itemStack) {
            if (itemStack != null && itemStack.func_77973_b() instanceof IProfilable) {
                return (IProfilable)itemStack.func_77973_b();
            }
            return null;
        }

        public static int getProfileIndex(ItemStack itemStack) {
            int index = 0;
            IProfilable profilable = Profilable.getProfilable(itemStack);
            if (profilable != null) {
                index = profilable.getProfileIndex(itemStack);
            }
            return index;
        }

        public static int getMaxProfiles(ItemStack itemStack) {
            int max = 0;
            IProfilable profilable = Profilable.getProfilable(itemStack);
            if (profilable != null) {
                max = profilable.getMaxProfiles(itemStack);
            }
            return max;
        }

        public static void setProfileIndex(ItemStack itemStack, int index) {
            IProfilable profilable = Profilable.getProfilable(itemStack);
            if (profilable != null) {
                profilable.setProfileIndex(itemStack, index);
            }
        }

        public static NBTTagCompound getProfileNBT(ItemStack itemStack) {
            NBTTagCompound tag = new NBTTagCompound();
            IProfilable profilable = Profilable.getProfilable(itemStack);
            if (profilable != null) {
                NBTHelper.checkNBT((ItemStack)itemStack);
                tag = profilable.getProfiles(itemStack).func_150305_b(profilable.getProfileIndex(itemStack));
            }
            return tag;
        }

        public static void setProfileNBT(ItemStack itemStack, NBTTagCompound tag) {
            IProfilable profilable = Profilable.getProfilable(itemStack);
            if (profilable != null) {
                NBTHelper.checkNBT((ItemStack)itemStack);
                profilable.getProfiles(itemStack).func_150305_b(profilable.getProfileIndex(itemStack)).func_179237_a(tag);
            }
        }
    }
}

