/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.tile;

import WayofTime.bloodmagic.tile.base.TileBase;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileInventory
extends TileBase
implements IInventory {
    protected int[] syncedSlots = new int[0];
    protected List<ItemStack> inventory;
    private int size;
    private String name;
    IItemHandler handlerDown;
    IItemHandler handlerUp;
    IItemHandler handlerNorth;
    IItemHandler handlerSouth;
    IItemHandler handlerWest;
    IItemHandler handlerEast;

    public TileInventory(int size, String name) {
        this.inventory = new ArrayList<ItemStack>(size);
        this.size = size;
        this.name = name;
        this.initializeItemHandlers();
    }

    protected boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void deserialize(NBTTagCompound tagCompound) {
        super.deserialize(tagCompound);
        NBTTagList tags = tagCompound.func_150295_c("Items", 10);
        this.inventory = new ArrayList<ItemStack>(this.size);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data;
            byte j;
            if (this.isSyncedSlot(i) || (j = (data = tags.func_150305_b(i)).func_74771_c("Slot")) < 0 || j >= this.inventory.size()) continue;
            this.inventory.set(j, ItemStack.func_77949_a((NBTTagCompound)data));
        }
    }

    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        super.serialize(tagCompound);
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (this.inventory.get(i) == null || this.isSyncedSlot(i)) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory.get(i).func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tags);
        return tagCompound;
    }

    public void dropItems() {
        InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory != null && !this.inventory.isEmpty() ? this.inventory.get(index) : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.func_70301_a(index) != null) {
            if (!this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
            if (this.func_70301_a((int)index).field_77994_a <= count) {
                ItemStack itemStack = this.inventory.get(index);
                this.inventory.set(index, null);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.inventory.get(index).func_77979_a(count);
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory.get(slot) != null) {
            ItemStack itemStack = this.inventory.get(slot);
            this.func_70299_a(slot, null);
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = new ArrayList<ItemStack>(this.size);
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public String func_70005_c_() {
        return TextHelper.localize((String)("tile.bloodarsenal." + this.name + ".name"), (Object[])new Object[0]);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    protected void initializeItemHandlers() {
        if (this instanceof ISidedInventory) {
            this.handlerDown = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
            this.handlerUp = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
            this.handlerNorth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
            this.handlerSouth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
            this.handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
            this.handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
        } else {
            this.handlerUp = this.handlerDown = new InvWrapper((IInventory)this);
            this.handlerNorth = this.handlerDown;
            this.handlerSouth = this.handlerDown;
            this.handlerWest = this.handlerDown;
            this.handlerEast = this.handlerDown;
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return (T)this.handlerDown;
                }
                case EAST: {
                    return (T)this.handlerEast;
                }
                case NORTH: {
                    return (T)this.handlerNorth;
                }
                case SOUTH: {
                    return (T)this.handlerSouth;
                }
                case UP: {
                    return (T)this.handlerUp;
                }
                case WEST: {
                    return (T)this.handlerWest;
                }
            }
        } else if (facing == null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerDown;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

