/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.tile;

import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.registry.AltarRecipeRegistry;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.block.BlockAltareAenigmatica;
import arc.bloodarsenal.tile.TileInventory;
import com.google.common.base.Strings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileAltareAenigmatica
extends TileInventory
implements ISidedInventory,
ITickable {
    public static final int ORB_SLOT = 9;
    private BlockPos altarPos = BlockPos.field_177992_a;
    private String linkedOrbOwner = "";

    public TileAltareAenigmatica() {
        super(10, "altareAenigmatica");
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.altarPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
        this.linkedOrbOwner = tag.func_74779_i("ownerUUID");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74768_a("xCoord", this.altarPos.func_177958_n());
        tag.func_74768_a("yCoord", this.altarPos.func_177956_o());
        tag.func_74768_a("zCoord", this.altarPos.func_177952_p());
        tag.func_74778_a("ownerUUID", this.linkedOrbOwner);
        return tag;
    }

    public int[] func_180463_a(EnumFacing side) {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAltareAenigmatica) {
            BlockAltareAenigmatica aenigmatica = (BlockAltareAenigmatica)state.func_177230_c();
            if (EnumFacing.values()[aenigmatica.func_176201_c(state)] == side) {
                return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
            }
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void func_73660_a() {
        TileInventory tile;
        if (this.altarPos != BlockPos.field_177992_a && (tile = (TileInventory)this.func_145831_w().func_175625_s(this.altarPos)) instanceof IBloodAltar && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) instanceof InvWrapper) {
            IBloodAltar altar = (IBloodAltar)tile;
            ItemStack orbStack = this.func_70301_a(9);
            IItemHandler altarInventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            boolean inThis = this.checkOrb(orbStack);
            boolean inAltar = this.checkOrb(altarInventory.getStackInSlot(0));
            if (inThis) {
                this.manageAltar(altarInventory, orbStack, altar);
            } else if (inAltar) {
                this.manageAltar(altarInventory, altarInventory.getStackInSlot(0), altar);
            }
        }
    }

    private boolean canInsertIntoAltar(IItemHandler altarInventory) {
        return altarInventory.getStackInSlot(0) == null || this.checkOrb(altarInventory.getStackInSlot(0));
    }

    private boolean checkOrb(ItemStack orbStack) {
        return orbStack != null && orbStack.func_77973_b() instanceof IBloodOrb && orbStack.func_77973_b() instanceof IBindable && ((IBindable)orbStack.func_77973_b()).getOwnerName(orbStack).equals(this.linkedOrbOwner);
    }

    private void manageAltar(IItemHandler altarInventory, ItemStack orbStack, IBloodAltar altar) {
        IBloodOrb orb = (IBloodOrb)orbStack.func_77973_b();
        IBindable sameOrb = (IBindable)orb;
        if (!Strings.isNullOrEmpty((String)sameOrb.getOwnerName(orbStack)) && this.canInsertIntoAltar(altarInventory)) {
            ItemStack stackInSlot = null;
            int slot = -1;
            for (int i = 0; i < 9; ++i) {
                if (this.func_70301_a(i) == null) continue;
                stackInSlot = this.func_70301_a(i);
                slot = i;
                break;
            }
            int altarEssence = altar.getCurrentBlood();
            if (stackInSlot != null && slot > -1) {
                AltarRecipeRegistry.AltarRecipe altarRecipe = AltarRecipeRegistry.getRecipeForInput((ItemStack)stackInSlot);
                if (altarRecipe != null && altarRecipe.doesRequiredItemMatch(stackInSlot, altar.getTier())) {
                    if (this.checkOrb(altarInventory.getStackInSlot(0))) {
                        ItemStack copyStack = altarInventory.getStackInSlot(0).func_77946_l();
                        altarInventory.extractItem(0, 1, false);
                        this.func_70299_a(9, copyStack);
                    } else if (altarRecipe.getSyphon() * stackInSlot.field_77994_a <= altarEssence && NetworkHelper.canSyphonFromContainer((ItemStack)orbStack, (int)(stackInSlot.field_77994_a * ConfigHandler.altareAenigmaticaMoveMultiplier))) {
                        altarInventory.insertItem(0, stackInSlot.func_77946_l(), false);
                        this.func_70299_a(slot, null);
                        NetworkHelper.syphonFromContainer((ItemStack)orbStack, (int)(stackInSlot.field_77994_a * ConfigHandler.altareAenigmaticaMoveMultiplier));
                    }
                } else {
                    this.shoveOrbIntoAltar(altarInventory, orbStack);
                }
            } else if (altarInventory.getStackInSlot(0) != null) {
                this.shoveOrbIntoAltar(altarInventory, orbStack);
            }
        }
    }

    private void shoveOrbIntoAltar(IItemHandler altarInventory, ItemStack orbStack) {
        ItemStack copyStack = orbStack.func_77946_l();
        this.func_70299_a(9, null);
        altarInventory.insertItem(0, copyStack, false);
    }

    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public void setAltarPos(BlockPos pos) {
        this.altarPos = pos;
    }

    public boolean setLinkedOrbOwner(EntityPlayer player) {
        String dontKnowWhatToCallThis = ((IBindable)player.func_184614_ca().func_77973_b()).getOwnerName(player.func_184614_ca());
        if (this.linkedOrbOwner.equals(dontKnowWhatToCallThis)) {
            ChatUtil.sendNoSpamClient((String[])new String[]{TextHelper.localize((String)"chat.BloodArsenal.alreadyOwner", (Object[])new Object[0])});
            return false;
        }
        this.linkedOrbOwner = dontKnowWhatToCallThis;
        ChatUtil.sendNoSpamClient((String[])new String[]{TextHelper.localize((String)"chat.BloodArsenal.setOwner", (Object[])new Object[]{player.func_70005_c_()})});
        return true;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

