/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.ritual;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.util.helper.ItemHelper;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import arc.bloodarsenal.modifier.IModifiableItem;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierHelper;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.registry.ModItems;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualModifierRemove
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualModifierRemove() {
        super("ritualUpgradeRemove", 0, 25000, "ritual.BloodMagic.upgradeRemoveRitual");
        this.addBlockRange(CHECK_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor checkRange = this.getBlockRange(CHECK_RANGE);
        List itemList = world.func_72872_a(EntityItem.class, checkRange.getAABB(pos));
        boolean modifierRemove = false;
        for (EntityItem entityItem : itemList) {
            StasisModifiable modifiable;
            boolean removedModifier = false;
            ItemStack itemStack = entityItem.func_92059_d();
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IModifiableItem) || (modifiable = StasisModifiable.getStasisModifiable(itemStack)) == null) continue;
            HashMap modifierMap = (HashMap)modifiable.modifierMap.clone();
            for (Map.Entry entry : modifierMap.entrySet()) {
                Modifier modifier = (Modifier)entry.getValue();
                String modifierKey = (String)entry.getKey();
                ItemStack modifierStack = new ItemStack(ModItems.MODIFIER_TOME);
                NBTHelper.checkNBT((ItemStack)modifierStack);
                ModifierHelper.setKey(modifierStack, modifierKey);
                ModifierHelper.setLevel(modifierStack, modifier.getLevel());
                ModifierHelper.setReady(modifierStack, modifier.readyForUpgrade());
                modifier.writeSpecialNBT(modifierStack, ItemStack.func_77949_a((NBTTagCompound)itemStack.func_77978_p().func_74775_l("itemStack")));
                boolean successful = modifiable.removeModifier(modifier);
                if (!successful) continue;
                modifierRemove = true;
                removedModifier = true;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, modifierStack));
                for (Map.Entry<String, ModifierTracker> trackerEntry : modifiable.trackerMap.entrySet()) {
                    ModifierTracker tracker = trackerEntry.getValue();
                    if (tracker == null || !tracker.providesModifier(modifierKey)) continue;
                    tracker.resetTracker();
                }
            }
            if (!removedModifier) continue;
            StasisModifiable.setStasisModifiable(itemStack, modifiable, true);
            StasisModifiable.setStasisModifiable(itemStack, modifiable);
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
        if (modifierRemove) {
            return;
        }
        List playerList = world.func_72872_a(EntityPlayer.class, checkRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            if (!LivingArmour.hasFullSet((EntityPlayer)player)) continue;
            boolean removedUpgrade = false;
            ItemStack chestStack = ((ItemStack[])Iterables.toArray((Iterable)player.func_184193_aE(), ItemStack.class))[2];
            LivingArmour armour = ItemLivingArmour.getLivingArmour((ItemStack)chestStack);
            if (armour == null) continue;
            HashMap upgradeMap = (HashMap)armour.upgradeMap.clone();
            for (Map.Entry entry : upgradeMap.entrySet()) {
                LivingArmourUpgrade upgrade = (LivingArmourUpgrade)entry.getValue();
                String upgradeKey = (String)entry.getKey();
                ItemStack upgradeStack = new ItemStack(WayofTime.bloodmagic.registry.ModItems.UPGRADE_TOME);
                ItemHelper.LivingUpgrades.setKey((ItemStack)upgradeStack, (String)upgradeKey);
                ItemHelper.LivingUpgrades.setLevel((ItemStack)upgradeStack, (int)upgrade.getUpgradeLevel());
                boolean successful = armour.removeUpgrade(player, upgrade);
                if (!successful) continue;
                removedUpgrade = true;
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, upgradeStack));
                for (Map.Entry trackerEntry : armour.trackerMap.entrySet()) {
                    StatTracker tracker = (StatTracker)trackerEntry.getValue();
                    if (tracker == null || !tracker.providesUpgrade(upgradeKey)) continue;
                    tracker.resetTracker();
                }
            }
            if (!removedUpgrade) continue;
            ((ItemLivingArmour)chestStack.func_77973_b()).setLivingArmour(chestStack, armour, true);
            ItemLivingArmour.setLivingArmour((ItemStack)chestStack, (LivingArmour)armour);
            armour.recalculateUpgradePoints();
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
    }

    public int getRefreshTime() {
        return 1;
    }

    public int getRefreshCost() {
        return 0;
    }

    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
        return components;
    }

    public Ritual getNewCopy() {
        return new RitualModifierRemove();
    }
}

