/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.ritual;

import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import arc.bloodarsenal.block.BlockStasisPlate;
import arc.bloodarsenal.modifier.IModifiableItem;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.recipe.RecipeSanguineInfusion;
import arc.bloodarsenal.recipe.SanguineInfusionRecipeRegistry;
import arc.bloodarsenal.ritual.RitualBloodArsenal;
import arc.bloodarsenal.tile.TileStasisPlate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualInfusion
extends RitualBloodArsenal {
    private BlockPos[] stasisPlatePositions = new BlockPos[]{new BlockPos(1, 1, 3), new BlockPos(-1, 1, 3), new BlockPos(1, 1, -3), new BlockPos(-1, 1, -3), new BlockPos(3, 1, 1), new BlockPos(3, 1, -1), new BlockPos(-3, 1, 1), new BlockPos(-3, 1, -1)};
    private int craftingTimer = 0;
    private boolean isCrafting = false;
    private final int CONSTANT_OF_INFUSION = 100;

    public RitualInfusion() {
        super("infusion", 0, 100, 1, 0);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        if (this.checkStructure(world, pos)) {
            List<ItemStack> inputStacks = this.getItemStackInputs(world, pos);
            List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
            ItemStack wildStack = null;
            Class wildClass = null;
            block0: for (ItemStack itemStack : inputStacks) {
                for (Class clazz : SanguineInfusionRecipeRegistry.getBlacklistedClasses()) {
                    if (!clazz.isInstance(itemStack.func_77973_b())) continue;
                    wildStack = itemStack;
                    wildClass = clazz;
                    inputStacks.remove(itemStack);
                    break block0;
                }
            }
            RecipeSanguineInfusion recipe = SanguineInfusionRecipeRegistry.getRecipeFromInputs(inputStacks);
            IInventory altarInv = (IInventory)world.func_175625_s(pos.func_177982_a(0, 1, 0));
            ItemStack input = altarInv.func_70301_a(0);
            if (recipe != null && altarInv != null) {
                if (recipe.isSpecial() && (wildClass == null || wildStack == null || !wildClass.isInstance(wildStack.func_77973_b()))) {
                    this.endRitual(world, pos, masterRitualStone);
                    return;
                }
                if (recipe.getFilter() != null && !recipe.getFilter().matches(wildStack)) {
                    this.endRitual(world, pos, masterRitualStone);
                    return;
                }
                if (recipe.isModifier()) {
                    if (input != null && input.func_77973_b() instanceof IModifiableItem) {
                        StasisModifiable modifiable = StasisModifiable.getModFromNBT(input);
                        if (modifiable == null) {
                            this.endRitual(world, pos, masterRitualStone);
                            return;
                        }
                        Modifier modifier = recipe.getModifier();
                        Modifier originalModifier = modifiable.getModifier(modifier.getClass());
                        int modifierLevel = -1;
                        for (int i = recipe.getModifier().getMaxLevel() - 1; i >= 0; --i) {
                            if (!recipe.matches(inputStacks, i)) continue;
                            modifierLevel = i;
                            break;
                        }
                        NBTTagCompound specialNBT = null;
                        if (originalModifier == Modifier.EMPTY_MODIFIER && modifierLevel >= 0) {
                            modifierLevel = 0;
                        } else if (originalModifier.readyForUpgrade() && modifierLevel > originalModifier.getLevel()) {
                            if (originalModifier.getSpecialNBT(input) != null) {
                                specialNBT = originalModifier.getSpecialNBT(input);
                            }
                            modifierLevel = originalModifier.getLevel() + 1;
                        } else {
                            this.endRitual(world, pos, masterRitualStone);
                            return;
                        }
                        if (specialNBT != null && !recipe.matchesWithSpecificity(wildStack, ItemStack.func_77949_a((NBTTagCompound)specialNBT.func_74775_l("itemStack")))) {
                            this.endRitual(world, pos, masterRitualStone);
                            return;
                        }
                        modifier.setLevel(modifierLevel);
                        if (!modifiable.canApplyModifier(modifier)) {
                            this.endRitual(world, pos, masterRitualStone);
                            return;
                        }
                        this.tickCrafting(masterRitualStone);
                        if (this.craftingTimer == recipe.getLpCost() * (modifierLevel + 1) / 100 && modifiable.applyModifier(modifier)) {
                            ItemStack copyStack = input.func_77946_l();
                            NBTHelper.checkNBT((ItemStack)copyStack);
                            modifier.removeSpecialNBT(copyStack);
                            modifier.writeSpecialNBT(copyStack, wildStack);
                            if (!StasisModifiable.hasModifiable(copyStack)) {
                                StasisModifiable.setStasisModifiable(copyStack, StasisModifiable.getModFromNBT(copyStack));
                            }
                            StasisModifiable.setStasisModifiable(copyStack, modifiable);
                            this.shrinkItemStackInputs(world, pos, recipe.getInputsForLevel(modifierLevel), wildStack);
                            altarInv.func_70299_a(0, copyStack);
                            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)masterRitualStone.getBlockPos().func_177958_n(), (double)(masterRitualStone.getBlockPos().func_177956_o() + 1), (double)masterRitualStone.getBlockPos().func_177952_p(), true));
                            this.endRitual(world, pos, masterRitualStone);
                            return;
                        }
                        if (!this.isCrafting) {
                            this.setStasisPlates(world, stasisPlates, true);
                            this.isCrafting = true;
                        }
                    } else {
                        this.endRitual(world, pos, masterRitualStone);
                    }
                } else if (this.isCrafting) {
                    this.tickCrafting(masterRitualStone);
                    if (this.craftingTimer == recipe.getLpCost() / 100) {
                        this.shrinkItemStackInputs(world, pos, recipe.getItemStackInputs(), null);
                        altarInv.func_70299_a(0, recipe.getOutput());
                        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)masterRitualStone.getBlockPos().func_177958_n(), (double)masterRitualStone.getBlockPos().func_177956_o(), (double)masterRitualStone.getBlockPos().func_177952_p(), true));
                        this.endRitual(world, pos, masterRitualStone);
                    }
                } else if (ItemStack.func_179545_c((ItemStack)recipe.getInfuse(), (ItemStack)input)) {
                    this.setStasisPlates(world, stasisPlates, true);
                    this.isCrafting = true;
                }
            } else {
                this.endRitual(world, pos, masterRitualStone);
            }
        } else {
            this.endRitual(world, pos, masterRitualStone);
        }
    }

    private void tickCrafting(IMasterRitualStone mrs) {
        if (!this.isCrafting) {
            return;
        }
        ++this.craftingTimer;
        NetworkHelper.getSoulNetwork((String)mrs.getOwner()).syphon(100);
    }

    private void endRitual(World world, BlockPos pos, IMasterRitualStone mrs) {
        List<TileStasisPlate> stasisPlates = this.getStasisPlates(world, pos);
        this.setStasisPlates(world, stasisPlates, false);
        mrs.setActive(false);
    }

    private boolean checkStructure(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos.func_177982_a(0, 1, 0)) instanceof IBloodAltar)) {
            return false;
        }
        for (BlockPos stasisPlatePos : this.stasisPlatePositions) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)stasisPlatePos)).func_177230_c() instanceof BlockStasisPlate) continue;
            return false;
        }
        return true;
    }

    private List<TileStasisPlate> getStasisPlates(World world, BlockPos pos) {
        ArrayList<TileStasisPlate> stasisPlates = new ArrayList<TileStasisPlate>();
        for (BlockPos stasisPlatePos : this.stasisPlatePositions) {
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)) instanceof TileStasisPlate)) continue;
            stasisPlates.add((TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)stasisPlatePos)));
        }
        return stasisPlates;
    }

    private void setStasisPlates(World world, List<TileStasisPlate> stasisPlates, boolean stasis) {
        for (TileStasisPlate plate : stasisPlates) {
            if (!plate.getStasis()) continue;
            plate.setStasis(stasis);
            world.func_184138_a(plate.func_174877_v(), world.func_180495_p(plate.func_174877_v()), world.func_180495_p(plate.func_174877_v()), 3);
        }
    }

    private List<ItemStack> getItemStackInputs(World world, BlockPos pos) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (BlockPos stasisPlatePos : this.stasisPlatePositions) {
            TileStasisPlate plate;
            BlockPos actualPos = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(actualPos) instanceof TileStasisPlate) || (plate = (TileStasisPlate)world.func_175625_s(actualPos)).func_70301_a(0) == null) continue;
            stackList.add(plate.func_70301_a(0));
        }
        return stackList;
    }

    private void shrinkItemStackInputs(World world, BlockPos pos, List<ItemStack> recipeInputs, ItemStack extraStack) {
        for (BlockPos stasisPlatePos : this.stasisPlatePositions) {
            BlockPos platePosition = pos.func_177971_a((Vec3i)stasisPlatePos);
            if (!(world.func_175625_s(platePosition) instanceof TileStasisPlate)) continue;
            TileStasisPlate plate = (TileStasisPlate)world.func_175625_s(platePosition);
            ItemStack plateStack = plate.func_70301_a(0);
            if (plate == null) continue;
            for (ItemStack recipeInput : recipeInputs) {
                if (!ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)plateStack)) continue;
                plateStack.field_77994_a -= recipeInput.field_77994_a;
                plate.func_70299_a(0, plateStack);
            }
            if (extraStack == null || !ItemStack.func_179545_c((ItemStack)extraStack, (ItemStack)plateStack)) continue;
            --plateStack.field_77994_a;
            plate.func_70299_a(0, plateStack);
        }
    }

    @Override
    public ArrayList<RitualComponent> addComponents(ArrayList<RitualComponent> components) {
        this.addCornerRunes(components, 1, -1, EnumRuneType.WATER);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, -1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 4, -1, EnumRuneType.WATER);
        this.addParallelRunes(components, 5, -1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 2, 5, 0, EnumRuneType.BLANK);
        this.addOffsetRunes(components, 3, 5, 0, EnumRuneType.BLANK);
        this.addOffsetRunes(components, 4, 5, 0, EnumRuneType.BLANK);
        this.addCornerRunes(components, 4, 1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 2, 5, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 2, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 5, 2, EnumRuneType.FIRE);
        this.addCornerRunes(components, 4, 3, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 2, 5, 3, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 5, 4, EnumRuneType.WATER);
        this.addOffsetRunes(components, 3, 4, 4, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 5, EnumRuneType.AIR);
        this.addCornerRunes(components, 3, 5, EnumRuneType.AIR);
        this.addOffsetRunes(components, 2, 3, 5, EnumRuneType.DUSK);
        this.addParallelRunes(components, 3, 6, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 1, 3, 6, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 6, EnumRuneType.DUSK);
        return components;
    }

    public Ritual getNewCopy() {
        return new RitualInfusion();
    }
}

