/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.registry;

import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.item.ItemBloodArsenalBase;
import arc.bloodarsenal.item.ItemBloodDiamond;
import arc.bloodarsenal.item.ItemBloodOrange;
import arc.bloodarsenal.item.ItemGem;
import arc.bloodarsenal.item.ItemModifierTome;
import arc.bloodarsenal.item.block.ItemBlockSpecialBloodArsenal;
import arc.bloodarsenal.item.sigil.ItemSigilAugmentedHolding;
import arc.bloodarsenal.item.sigil.ItemSigilDivinity;
import arc.bloodarsenal.item.sigil.ItemSigilEnder;
import arc.bloodarsenal.item.sigil.ItemSigilLightning;
import arc.bloodarsenal.item.sigil.ItemSigilSentience;
import arc.bloodarsenal.item.sigil.ItemSigilSwimming;
import arc.bloodarsenal.item.stasis.ItemStasisAxe;
import arc.bloodarsenal.item.stasis.ItemStasisPickaxe;
import arc.bloodarsenal.item.stasis.ItemStasisShovel;
import arc.bloodarsenal.item.stasis.ItemStasisSword;
import arc.bloodarsenal.item.tool.ItemBloodInfusedIronAxe;
import arc.bloodarsenal.item.tool.ItemBloodInfusedIronPickaxe;
import arc.bloodarsenal.item.tool.ItemBloodInfusedIronShovel;
import arc.bloodarsenal.item.tool.ItemBloodInfusedIronSickle;
import arc.bloodarsenal.item.tool.ItemBloodInfusedIronSword;
import arc.bloodarsenal.item.tool.ItemBloodInfusedWoodenAxe;
import arc.bloodarsenal.item.tool.ItemBloodInfusedWoodenPickaxe;
import arc.bloodarsenal.item.tool.ItemBloodInfusedWoodenShovel;
import arc.bloodarsenal.item.tool.ItemBloodInfusedWoodenSickle;
import arc.bloodarsenal.item.tool.ItemBloodInfusedWoodenSword;
import arc.bloodarsenal.item.tool.ItemBoundSickle;
import arc.bloodarsenal.item.tool.ItemBoundStick;
import arc.bloodarsenal.item.tool.ItemGlassDaggerOfSacrifice;
import arc.bloodarsenal.item.tool.ItemGlassSacrificialDagger;
import arc.bloodarsenal.item.tool.ItemStygianDagger;
import arc.bloodarsenal.registry.ModBlocks;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ModItems {
    public static final Item GLASS_SHARD;
    public static final Item BLOOD_INFUSED_STICK;
    public static final Item BLOOD_BURNED_STRING;
    public static final Item BLOOD_ORANGE;
    public static final Item BLOOD_DIAMOND;
    public static final Item BLOOD_INFUSED_WOODEN_PICKAXE;
    public static final Item BLOOD_INFUSED_WOODEN_AXE;
    public static final Item BLOOD_INFUSED_WOODEN_SHOVEL;
    public static final Item BLOOD_INFUSED_WOODEN_SICKLE;
    public static final Item BLOOD_INFUSED_WOODEN_SWORD;
    public static final Item BLOOD_INFUSED_GLOWSTONE_DUST;
    public static final Item INERT_BLOOD_INFUSED_IRON_INGOT;
    public static final Item BLOOD_INFUSED_IRON_INGOT;
    public static final Item BLOOD_INFUSED_IRON_PICKAXE;
    public static final Item BLOOD_INFUSED_IRON_AXE;
    public static final Item BLOOD_INFUSED_IRON_SHOVEL;
    public static final Item BLOOD_INFUSED_IRON_SICKLE;
    public static final Item BLOOD_INFUSED_IRON_SWORD;
    public static final Item GLASS_SACRIFICIAL_DAGGER;
    public static final Item GLASS_DAGGER_OF_SACRIFICE;
    public static final Item STYGIAN_DAGGER;
    public static final Item GEM_SACRIFICE;
    public static final Item GEM_SELF_SACRIFICE;
    public static final Item GEM_TARTARIC;
    public static final Item SIGIL_SWIMMING;
    public static final Item SIGIL_ENDER;
    public static final Item SIGIL_AUGMENTED_HOLDING;
    public static final Item SIGIL_LIGHTNING;
    public static final Item SIGIL_DIVINITY;
    public static final Item SIGIL_SENTIENCE;
    public static final Item REAGENT_SWIMMING;
    public static final Item REAGENT_ENDER;
    public static final Item REAGENT_LIGHTNING;
    public static final Item REAGENT_DIVINITY;
    public static final Item BOUND_STICK;
    public static final Item BOUND_SICKLE;
    public static final Item STASIS_PLATE;
    public static final Item STASIS_PICKAXE;
    public static final Item STASIS_AXE;
    public static final Item STASIS_SHOVEL;
    public static final Item STASIS_SWORD;
    public static final Item MODIFIER_TOME;
    public static final Item.ToolMaterial BLOOD_INFUSED_WOOD;
    public static final Item.ToolMaterial BLOOD_INFUSED_IRON;
    public static final Item.ToolMaterial STASIS;

    public static void addOreDictItems() {
        OreDictionary.registerOre((String)"shardGlass", (Item)GLASS_SHARD);
        OreDictionary.registerOre((String)"ingotBloodInfusedIron", (Item)BLOOD_INFUSED_IRON_INGOT);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initSpecialRenders() {
        ResourceLocation holdingLoc = new ResourceLocation("bloodarsenal", "item/ItemSigilAugmentedHolding");
        ModelLoader.setCustomMeshDefinition((Item)SIGIL_AUGMENTED_HOLDING, stack -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("color") ? new ModelResourceLocation(holdingLoc, "type=color") : new ModelResourceLocation(holdingLoc, "type=normal"));
        ModelLoader.registerItemVariants((Item)SIGIL_AUGMENTED_HOLDING, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(holdingLoc, "type=normal")});
        ModelLoader.registerItemVariants((Item)SIGIL_AUGMENTED_HOLDING, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(holdingLoc, "type=color")});
    }

    public static Item registerItem(Item item) {
        item.setRegistryName(item.getClass().getSimpleName());
        if (item.getRegistryName() == null) {
            BloodArsenal.INSTANCE.getLogger().error("Attempted to register Item {} without setting a registry name. Item will not be registered. Please report this.", new Object[]{item.getClass().getCanonicalName()});
            return item;
        }
        String itemName = item.getRegistryName().toString().split(":")[1];
        if (!ConfigHandler.itemBlacklist.contains(itemName)) {
            GameRegistry.register((IForgeRegistryEntry)item);
            BloodArsenal.PROXY.tryHandleItemModel(item, itemName);
        }
        return item;
    }

    public static Item registerItemUniquely(Item item) {
        item.setRegistryName(item.getClass().getSimpleName() + "." + WordUtils.capitalize((String)item.func_77658_a().substring(18)));
        if (item.getRegistryName() == null) {
            BloodArsenal.INSTANCE.getLogger().error("Attempted to register Item {} without setting a registry name. Item will not be registered. Please report this.", new Object[]{item.getClass().getCanonicalName()});
            return item;
        }
        String itemName = item.getRegistryName().toString().split(":")[1];
        if (!ConfigHandler.itemBlacklist.contains(itemName)) {
            GameRegistry.register((IForgeRegistryEntry)item);
            BloodArsenal.PROXY.tryHandleItemModel(item, itemName.split("[.]")[0]);
        }
        return item;
    }

    static {
        BLOOD_INFUSED_WOOD = EnumHelper.addToolMaterial((String)"BloodInfusedWoodMaterial", (int)1, (int)186, (float)5.5f, (float)1.0f, (int)13);
        BLOOD_INFUSED_IRON = EnumHelper.addToolMaterial((String)"BloodInfusedIronMaterial", (int)3, (int)954, (float)7.25f, (float)2.7f, (int)21);
        STASIS = EnumHelper.addToolMaterial((String)"Stasis", (int)4, (int)0, (float)9.0f, (float)4.2f, (int)0);
        GLASS_SHARD = ModItems.registerItemUniquely(new ItemBloodArsenalBase("glassShard"));
        BLOOD_INFUSED_STICK = ModItems.registerItemUniquely(new ItemBloodArsenalBase("bloodInfusedStick"));
        BLOOD_BURNED_STRING = ModItems.registerItemUniquely((Item)new ItemBlockSpecialBloodArsenal("bloodBurnedString", ModBlocks.BLOOD_BURNED_STRING));
        BLOOD_ORANGE = ModItems.registerItem((Item)new ItemBloodOrange("bloodOrange"));
        BLOOD_DIAMOND = ModItems.registerItem(new ItemBloodDiamond("bloodDiamond"));
        BLOOD_INFUSED_WOODEN_PICKAXE = ModItems.registerItem((Item)new ItemBloodInfusedWoodenPickaxe());
        BLOOD_INFUSED_WOODEN_AXE = ModItems.registerItem((Item)new ItemBloodInfusedWoodenAxe());
        BLOOD_INFUSED_WOODEN_SHOVEL = ModItems.registerItem((Item)new ItemBloodInfusedWoodenShovel());
        BLOOD_INFUSED_WOODEN_SICKLE = ModItems.registerItem((Item)new ItemBloodInfusedWoodenSickle());
        BLOOD_INFUSED_WOODEN_SWORD = ModItems.registerItem((Item)new ItemBloodInfusedWoodenSword());
        BLOOD_INFUSED_GLOWSTONE_DUST = ModItems.registerItemUniquely(new ItemBloodArsenalBase("bloodInfusedGlowstoneDust"));
        INERT_BLOOD_INFUSED_IRON_INGOT = ModItems.registerItemUniquely(new ItemBloodArsenalBase("inertBloodInfusedIronIngot"));
        BLOOD_INFUSED_IRON_INGOT = ModItems.registerItemUniquely(new ItemBloodArsenalBase("bloodInfusedIronIngot"));
        BLOOD_INFUSED_IRON_PICKAXE = ModItems.registerItem((Item)new ItemBloodInfusedIronPickaxe());
        BLOOD_INFUSED_IRON_AXE = ModItems.registerItem((Item)new ItemBloodInfusedIronAxe());
        BLOOD_INFUSED_IRON_SHOVEL = ModItems.registerItem((Item)new ItemBloodInfusedIronShovel());
        BLOOD_INFUSED_IRON_SICKLE = ModItems.registerItem((Item)new ItemBloodInfusedIronSickle());
        BLOOD_INFUSED_IRON_SWORD = ModItems.registerItem((Item)new ItemBloodInfusedIronSword());
        GLASS_SACRIFICIAL_DAGGER = ModItems.registerItem((Item)new ItemGlassSacrificialDagger("glassSacrificialDagger"));
        GLASS_DAGGER_OF_SACRIFICE = ModItems.registerItem((Item)new ItemGlassDaggerOfSacrifice("glassDaggerOfSacrifice"));
        STYGIAN_DAGGER = ModItems.registerItem((Item)new ItemStygianDagger("stygianDagger"));
        GEM_SACRIFICE = ModItems.registerItemUniquely(new ItemGem("sacrifice"));
        GEM_SELF_SACRIFICE = ModItems.registerItemUniquely(new ItemGem("selfSacrifice"));
        GEM_TARTARIC = ModItems.registerItemUniquely(new ItemGem("tartaric"));
        SIGIL_SWIMMING = ModItems.registerItem((Item)new ItemSigilSwimming());
        SIGIL_ENDER = ModItems.registerItem((Item)new ItemSigilEnder());
        SIGIL_AUGMENTED_HOLDING = ModItems.registerItem((Item)new ItemSigilAugmentedHolding());
        SIGIL_LIGHTNING = ModItems.registerItem((Item)new ItemSigilLightning());
        SIGIL_DIVINITY = ModItems.registerItem((Item)new ItemSigilDivinity());
        SIGIL_SENTIENCE = ModItems.registerItem((Item)new ItemSigilSentience());
        REAGENT_SWIMMING = ModItems.registerItemUniquely(new ItemBloodArsenalBase("reagentSwimming"));
        REAGENT_ENDER = ModItems.registerItemUniquely(new ItemBloodArsenalBase("reagentEnder"));
        REAGENT_LIGHTNING = ModItems.registerItemUniquely(new ItemBloodArsenalBase("reagentLightning"));
        REAGENT_DIVINITY = ModItems.registerItemUniquely(new ItemBloodArsenalBase("reagentDivinity"));
        BOUND_STICK = ModItems.registerItem((Item)new ItemBoundStick("boundStick"));
        BOUND_SICKLE = ModItems.registerItem((Item)new ItemBoundSickle());
        STASIS_PLATE = ModItems.registerItemUniquely(new ItemBloodArsenalBase("stasisPlate"));
        STASIS_PICKAXE = ModItems.registerItem((Item)new ItemStasisPickaxe());
        STASIS_AXE = ModItems.registerItem((Item)new ItemStasisAxe());
        STASIS_SHOVEL = ModItems.registerItem((Item)new ItemStasisShovel());
        STASIS_SWORD = ModItems.registerItem((Item)new ItemStasisSword());
        MODIFIER_TOME = ModItems.registerItem(new ItemModifierTome("modifierTome"));
    }
}

