/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.registry;

import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.block.BlockAltareAenigmatica;
import arc.bloodarsenal.block.BlockBloodBurnedString;
import arc.bloodarsenal.block.BlockBloodInfusedGlowstone;
import arc.bloodarsenal.block.BlockBloodInfusedIron;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenFence;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenFenceGate;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenLog;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenPlanks;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenSlab;
import arc.bloodarsenal.block.BlockBloodInfusedWoodenStairs;
import arc.bloodarsenal.block.BlockBloodStainedGlass;
import arc.bloodarsenal.block.BlockBloodStainedGlassPane;
import arc.bloodarsenal.block.BlockBloodTorch;
import arc.bloodarsenal.block.BlockGlassShard;
import arc.bloodarsenal.block.BlockSlate;
import arc.bloodarsenal.block.BlockStasisPlate;
import arc.bloodarsenal.item.block.ItemBlockBloodInfusedWoodenSlab;
import arc.bloodarsenal.item.block.ItemBlockSlate;
import arc.bloodarsenal.tile.TileAltareAenigmatica;
import arc.bloodarsenal.tile.TileStasisPlate;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class ModBlocks {
    public static final Block SLATE = ModBlocks.registerBlock(new ItemBlockSlate((Block)new BlockSlate("slate")));
    public static final Block BLOOD_INFUSED_WOODEN_LOG = ModBlocks.registerBlock((Block)new BlockBloodInfusedWoodenLog("bloodInfusedWoodenLog"));
    public static final Block BLOOD_INFUSED_WOODEN_PLANKS = ModBlocks.registerBlock(new BlockBloodInfusedWoodenPlanks("bloodInfusedWoodenPlanks"));
    public static final Block BLOOD_INFUSED_WOODEN_STAIRS = ModBlocks.registerBlock((Block)new BlockBloodInfusedWoodenStairs("bloodInfusedWoodenStairs", BLOOD_INFUSED_WOODEN_PLANKS));
    public static final Block BLOOD_INFUSED_WOODEN_DOUBLE_SLAB = ModBlocks.registerBlock(new BlockBloodInfusedWoodenSlab.BlockBloodInfusedWoodenDoubleSlab().func_149663_c("bloodarsenal.bloodInfusedWoodenDoubleSlab"));
    public static final Block BLOOD_INFUSED_WOODEN_SLAB = ModBlocks.registerBlock((ItemBlock)new ItemBlockBloodInfusedWoodenSlab("bloodInfusedWoodenSlab"));
    public static final Block BLOOD_INFUSED_WOODEN_FENCE = ModBlocks.registerBlock((Block)new BlockBloodInfusedWoodenFence("bloodInfusedWoodenFence"));
    public static final Block BLOOD_INFUSED_WOODEN_FENCE_GATE = ModBlocks.registerBlock((Block)new BlockBloodInfusedWoodenFenceGate("bloodInfusedWoodenFenceGate"));
    public static final Block BLOOD_STAINED_GLASS = ModBlocks.registerBlock((Block)new BlockBloodStainedGlass("bloodStainedGlass"));
    public static final Block BLOOD_STAINED_GLASS_PANE = ModBlocks.registerBlock((Block)new BlockBloodStainedGlassPane("bloodStainedGlassPane"));
    public static final Block BLOOD_TORCH = ModBlocks.registerBlock((Block)new BlockBloodTorch("bloodTorch"));
    public static final Block BLOOD_INFUSED_IRON_BLOCK = ModBlocks.registerBlock(new BlockBloodInfusedIron("bloodInfusedIronBlock"));
    public static final Block BLOOD_INFUSED_GLOWSTONE = ModBlocks.registerBlock(new BlockBloodInfusedGlowstone("bloodInfusedGlowstone"));
    public static final Block GLASS_SHARD_BLOCK = ModBlocks.registerBlock(new BlockGlassShard("glassShardBlock"));
    public static final Block BLOOD_BURNED_STRING = ModBlocks.registerBlock((Block)new BlockBloodBurnedString("bloodBurnedString"));
    public static final Block ALTARE_AENIGMATICA = ModBlocks.registerBlock(new BlockAltareAenigmatica("altareAenigmatica"));
    public static final Block STASIS_PLATE = ModBlocks.registerBlock(new BlockStasisPlate("stasisPlate"));

    public static void addOreDictBlocks() {
        OreDictionary.registerOre((String)"blockBloodInfusedIron", (Block)BLOOD_INFUSED_IRON_BLOCK);
    }

    public static void initTiles() {
        ModBlocks.registerTile(TileAltareAenigmatica.class);
        ModBlocks.registerTile(TileStasisPlate.class);
    }

    public static Block registerBlock(Block block, String name) {
        if (!ConfigHandler.blockBlacklist.contains(name)) {
            GameRegistry.register((IForgeRegistryEntry)block);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(name));
            BloodArsenal.PROXY.tryHandleBlockModel(block, name);
        }
        return block;
    }

    public static Block registerBlock(ItemBlock itemBlock) {
        Block block = itemBlock.field_150939_a;
        block.setRegistryName(block.getClass().getSimpleName());
        if (block.getRegistryName() == null) {
            BloodArsenal.INSTANCE.getLogger().error("Attempted to register Block {} without setting a registry name. Block will not be registered. Please report this.", new Object[]{block.getClass().getCanonicalName()});
            return block;
        }
        String blockName = block.getRegistryName().toString().split(":")[1];
        if (!ConfigHandler.blockBlacklist.contains(blockName)) {
            GameRegistry.register((IForgeRegistryEntry)block);
            GameRegistry.register((IForgeRegistryEntry)itemBlock.setRegistryName(block.getRegistryName().func_110623_a()));
            BloodArsenal.PROXY.tryHandleBlockModel(block, blockName);
        }
        return block;
    }

    public static Block registerBlock(Block block) {
        block.setRegistryName(block.getClass().getSimpleName());
        if (block.getRegistryName() == null) {
            BloodArsenal.INSTANCE.getLogger().error("Attempted to register Block {} without setting a registry name. Block will not be registered. Please report this.", new Object[]{block.getClass().getCanonicalName()});
            return null;
        }
        String blockName = block.getRegistryName().toString().split(":")[1];
        if (!ConfigHandler.blockBlacklist.contains(blockName)) {
            GameRegistry.register((IForgeRegistryEntry)block);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName().func_110623_a()));
            BloodArsenal.PROXY.tryHandleBlockModel(block, blockName);
        }
        return block;
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        GameRegistry.registerTileEntity(tile, (String)("bloodarsenal:" + tile.getSimpleName()));
    }
}

