/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.recipe;

import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.recipe.RecipeSanguineInfusion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class SanguineInfusionRecipeRegistry {
    private static List<RecipeSanguineInfusion> infusionRecipes = new ArrayList<RecipeSanguineInfusion>();
    private static List<Class> blacklistedClasses = new ArrayList<Class>();

    public static void registerSanguineInfusionRecipe(ItemStack output, int lpCost, ItemStack infuse, Object ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(output, lpCost, infuse, inputs);
        infusionRecipes.add(recipe);
    }

    public static void registerModificationRecipe(int lpCost, Modifier modifier, int levelMultiplier, Object ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(lpCost, modifier, inputs).setLevelMultiplier(levelMultiplier);
        infusionRecipes.add(recipe);
    }

    public static void registerModificationRecipe(int lpCost, Modifier modifier, int levelMultiplier, Class specialClass, Object ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(lpCost, modifier, inputs).setLevelMultiplier(levelMultiplier).setSpecial();
        infusionRecipes.add(recipe);
        blacklistedClasses.add(specialClass);
    }

    public static List<RecipeSanguineInfusion> getInfusionRecipes() {
        return infusionRecipes;
    }

    public static List<Class> getBlacklistedClasses() {
        return blacklistedClasses;
    }

    public static RecipeSanguineInfusion getRecipeFromInputs(List<ItemStack> inputs) {
        for (RecipeSanguineInfusion recipe : infusionRecipes) {
            if (!recipe.matches(inputs)) continue;
            return recipe;
        }
        return null;
    }
}

