/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.recipe;

import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.recipe.RecipeFilter;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;

public class RecipeSanguineInfusion {
    private final ItemStack output;
    private final ItemStack infuse;
    private final ImmutableList<Object> inputs;
    private final int lpCost;
    private boolean isModifier = false;
    private boolean isSpecial = false;
    private Modifier modifier = Modifier.EMPTY_MODIFIER;
    private int levelMultiplier = 1;
    private RecipeFilter filter = null;

    public RecipeSanguineInfusion(ItemStack output, int lpCost, ItemStack infuse, Object ... inputs) {
        this.output = output;
        this.infuse = infuse;
        this.lpCost = lpCost;
        ImmutableList.Builder inputsToSet = ImmutableList.builder();
        for (Object o : inputs) {
            if (o instanceof Item) {
                inputsToSet.add((Object)new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                inputsToSet.add((Object)new ItemStack((Block)o));
                continue;
            }
            if (o instanceof String || o instanceof ItemStack) {
                inputsToSet.add(o);
                continue;
            }
            if (o instanceof RecipeFilter) {
                this.filter = (RecipeFilter)o;
                continue;
            }
            throw new IllegalArgumentException("Invalid input");
        }
        this.inputs = inputsToSet.build();
    }

    public RecipeSanguineInfusion(int lpCost, Modifier modifier, Object ... inputs) {
        this.infuse = null;
        this.output = null;
        this.lpCost = lpCost;
        this.isModifier = true;
        this.modifier = modifier;
        ImmutableList.Builder inputsToSet = ImmutableList.builder();
        for (Object o : inputs) {
            if (o instanceof Item) {
                inputsToSet.add((Object)new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                inputsToSet.add((Object)new ItemStack((Block)o));
                continue;
            }
            if (o instanceof String || o instanceof ItemStack) {
                inputsToSet.add(o);
                continue;
            }
            if (o instanceof RecipeFilter) {
                this.filter = (RecipeFilter)o;
                continue;
            }
            throw new IllegalArgumentException("Invalid input");
        }
        this.inputs = inputsToSet.build();
    }

    public RecipeSanguineInfusion setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public RecipeSanguineInfusion setLevelMultiplier(int levelMultiplier) {
        this.levelMultiplier = levelMultiplier;
        return this;
    }

    public List<Object> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getItemStackInputs() {
        ArrayList<ItemStack> stackSet = new ArrayList<ItemStack>();
        for (Object o : this.inputs) {
            if (o instanceof ItemStack) {
                stackSet.add((ItemStack)o);
                continue;
            }
            if (!(o instanceof String)) continue;
            stackSet.add(BloodArsenalUtils.resolveObject(o));
        }
        return stackSet;
    }

    public ItemStack getInfuse() {
        return this.infuse;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getLpCost() {
        return this.lpCost;
    }

    public boolean isModifier() {
        return this.isModifier;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public int getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public List<ItemStack> getInputsForLevel(int modifierLevel) {
        if (modifierLevel < 0) {
            return this.getItemStackInputs();
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.getItemStackInputs()) {
            ItemStack dummyStack = itemStack.func_77946_l();
            dummyStack.field_77994_a = itemStack.field_77994_a * (modifierLevel + 1) * this.getLevelMultiplier();
            inputs.add(dummyStack);
        }
        return inputs;
    }

    public RecipeFilter getFilter() {
        return this.filter;
    }

    public boolean matches(List<ItemStack> itemStackInputs) {
        return this.matches(itemStackInputs, -1);
    }

    public boolean matches(List<ItemStack> itemStackInputs, int modifierLevel) {
        ArrayList<ItemStack> dummyList = new ArrayList<ItemStack>();
        dummyList.addAll(itemStackInputs);
        for (ItemStack ingredient : this.getInputsForLevel(modifierLevel)) {
            boolean foundIngredient = false;
            for (ItemStack input : dummyList) {
                if (!BloodArsenalUtils.areStacksEqual(ingredient, input) || ingredient != null && ingredient.func_77942_o() && !ItemStack.func_77970_a((ItemStack)ingredient, (ItemStack)input) || input.field_77994_a < ingredient.field_77994_a) continue;
                foundIngredient = true;
                dummyList.remove(input);
                break;
            }
            if (foundIngredient) continue;
            return false;
        }
        for (ItemStack input : dummyList) {
            if (input == null) continue;
            return false;
        }
        return true;
    }

    public boolean matchesWithSpecificity(ItemStack itemStack, ItemStack compareStack) {
        if (!PotionUtils.func_185189_a((ItemStack)itemStack).isEmpty() && !PotionUtils.func_185189_a((ItemStack)compareStack).isEmpty()) {
            Potion comparePotion;
            Potion potion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)itemStack).get(0)).func_188419_a();
            return potion == (comparePotion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)compareStack).get(0)).func_188419_a()) && (this.filter == null || this.filter.matches(itemStack)) && ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)compareStack);
        }
        return (this.filter == null || this.filter.matches(itemStack)) && ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)compareStack);
    }
}

