/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.proxy;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.InventoryRenderHelperV2;
import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.client.hud.HUDElementAugmentedHolding;
import arc.bloodarsenal.client.mesh.FluidStateMapper;
import arc.bloodarsenal.client.render.block.RenderStasisPlate;
import arc.bloodarsenal.client.render.entity.RenderSentientTool;
import arc.bloodarsenal.entity.projectile.EntitySummonedTool;
import arc.bloodarsenal.proxy.CommonProxy;
import arc.bloodarsenal.registry.ModItems;
import arc.bloodarsenal.tile.TileStasisPlate;
import arc.bloodarsenal.util.IComplexVariantProvider;
import arc.bloodarsenal.util.handler.ClientHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ClientProxy
extends CommonProxy {
    private InventoryRenderHelperV2 renderHelper;

    @Override
    public InventoryRenderHelperV2 getRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public void preInit() {
        super.preInit();
        this.renderHelper = new InventoryRenderHelperV2(BloodArsenal.DOMAIN);
        ModItems.initSpecialRenders();
        ClientRegistry.bindTileEntitySpecialRenderer(TileStasisPlate.class, (TileEntitySpecialRenderer)new RenderStasisPlate());
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySummonedTool.class, RenderSentientTool::new);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        new HUDElementAugmentedHolding();
    }

    @Override
    public void tryHandleBlockModel(Block block, String name) {
        IComplexVariantProvider complexVariantProvider;
        if (block instanceof IVariantProvider) {
            IVariantProvider variantProvider = (IVariantProvider)block;
            for (Pair variant : variantProvider.getVariants()) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)((Integer)variant.getLeft()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("bloodarsenal", name), (String)variant.getRight()));
            }
        }
        if (block instanceof IComplexVariantProvider && (complexVariantProvider = (IComplexVariantProvider)block).getIgnoredProperties() != null) {
            StateMap customMapper = new StateMap.Builder().func_178442_a(complexVariantProvider.getIgnoredProperties()).func_178441_a();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)customMapper);
        }
    }

    @Override
    public void tryHandleItemModel(Item item, String name) {
        block4: {
            block3: {
                if (!(item instanceof IMeshProvider)) break block3;
                IMeshProvider meshProvider = (IMeshProvider)item;
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshProvider.getMeshDefinition());
                ResourceLocation resourceLocation = meshProvider.getCustomLocation();
                if (resourceLocation == null) {
                    resourceLocation = new ResourceLocation("bloodarsenal", "item/" + name);
                }
                for (String variant : meshProvider.getVariants()) {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(resourceLocation, variant)});
                }
                break block4;
            }
            if (!(item instanceof IVariantProvider)) break block4;
            IVariantProvider variantProvider = (IVariantProvider)item;
            for (Pair variant : variantProvider.getVariants()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)variant.getLeft()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("bloodarsenal", "item/" + name), (String)variant.getRight()));
            }
        }
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != null) {
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }
}

