/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier.modifiers;

import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.registry.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ModifierSmelting
extends Modifier {
    public ModifierSmelting(int level) {
        super("smelting", Constants.Modifiers.SMELTING_COUNTER.length, level, EnumModifierType.CORE);
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityPlayer player) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return;
        }
        ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(blockStack);
        if (resultStack != null) {
            if (!(this.getLevel() > 0 || this.getLevel() == 0 && resultStack.func_77973_b() instanceof ItemBlock)) {
                resultStack = null;
            }
            world.func_175698_g(pos);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)resultStack);
            ModifierTracker.getTracker(this).incrementCounter(StasisModifiable.getStasisModifiable(itemStack), 1.0);
        } else {
            world.func_175698_g(pos);
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
    }
}

