/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier.modifiers;

import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.registry.Constants;
import arc.bloodarsenal.util.BloodArsenalUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ModifierFortunate
extends Modifier {
    public ModifierFortunate(int level) {
        super("fortunate", Constants.Modifiers.FORTUNATE_COUNTER.length, level, EnumModifierType.CORE);
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityPlayer player) {
        Block block = state.func_177230_c();
        if (block.getDrops((IBlockAccess)world, pos, state, this.getLevel() + 1).size() > block.getDrops((IBlockAccess)world, pos, state, 0).size()) {
            ModifierTracker.getTracker(this).incrementCounter(StasisModifiable.getStasisModifiable(itemStack), 1.0);
        }
    }

    @Override
    public void writeSpecialNBT(ItemStack itemStack, ItemStack extra) {
        BloodArsenalUtils.writeNBTEnchantment(itemStack, Enchantments.field_185308_t, this.getLevel() + 1);
    }

    @Override
    public void removeSpecialNBT(ItemStack itemStack) {
        BloodArsenalUtils.removeNBTEnchantment(itemStack, Enchantments.field_185308_t);
    }
}

