/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier.modifiers;

import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.registry.Constants;
import com.google.common.collect.Multimap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ModifierBloodlust
extends Modifier {
    private double multiplier = 0.0;

    public ModifierBloodlust(int level) {
        super("bloodlust", Constants.Modifiers.BLOODLUST_COUNTER.length, level, EnumModifierType.HEAD);
    }

    @Override
    public void onUpdate(ItemStack itemStack, World world, Entity entity, int itemSlot) {
        if (world.func_72820_D() % 5L == 0L && random.nextInt(3) < 2 && this.multiplier > 0.0) {
            this.multiplier = Math.max(this.multiplier - (0.02 + (double)random.nextInt(5) / 100.0), 0.0);
        }
    }

    @Override
    public void hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        this.multiplier = this.getMultiplier(this.multiplier + random.nextDouble() * (double)(this.getLevel() + 1) / 6.0);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("multiplier", this.multiplier);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.multiplier = tag.func_74769_h("multiplier");
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Constants.Misc.ATTACK_DAMAGE_MODIFIER, "Weapon modifier", Math.floor(this.multiplier / 4.0 + 1.0) * (6.0 + 0.5 * (double)(this.getLevel() + 1)) * Math.pow(1.1375, this.multiplier), 0));
        return multimap;
    }

    private double getMultiplier(double multiplier) {
        double max = 0.0;
        switch (this.getLevel() + 1) {
            case 1: {
                max = 4.0;
                break;
            }
            case 2: {
                max = 7.0;
                break;
            }
            case 3: {
                max = 10.0;
                break;
            }
            case 4: {
                max = 12.0;
                break;
            }
            case 5: {
                max = 14.0;
                break;
            }
            case 6: {
                max = 15.0;
                break;
            }
            case 7: {
                max = 16.0;
                break;
            }
            case 8: {
                max = 17.0;
            }
        }
        return Math.min(multiplier, max);
    }
}

