/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier.modifiers;

import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.registry.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;

public class ModifierBadPotion
extends Modifier {
    public ModifierBadPotion(int level) {
        super("badPotion", Constants.Modifiers.BAD_POTION_COUNTER.length, level, EnumModifierType.HEAD);
        this.setAltName();
    }

    @Override
    public String getAlternateName(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p().func_74779_i("itemStackName") : "\u4f55\u3060\u3088!";
    }

    @Override
    public void hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (random.nextInt(this.getLevel() + 1) >= random.nextInt(this.getMaxLevel()) && itemStack.func_77942_o()) {
            NBTTagCompound data = itemStack.func_77978_p().func_74775_l("itemStack");
            Potion potion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)ItemStack.func_77949_a((NBTTagCompound)data)).get(0)).func_188419_a();
            if (potion.func_76403_b()) {
                potion.func_180793_a((Entity)attacker, (Entity)attacker, target, this.getLevel(), 1.0);
            } else {
                target.func_70690_d(new PotionEffect(potion, 20 + 40 * (this.getLevel() + 1), this.getLevel()));
            }
            ModifierTracker.getTracker(this).incrementCounter(StasisModifiable.getStasisModifiable(itemStack), 1.0);
        }
    }

    @Override
    public void writeSpecialNBT(ItemStack itemStack, ItemStack extra) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagCompound potionTag = new NBTTagCompound();
        String potionName = "";
        if (extra != null && extra.func_77973_b() instanceof ItemPotion) {
            extra.func_77955_b(potionTag);
            potionName = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)extra).get(0)).func_188419_a().func_76393_a();
        }
        tag.func_74782_a("itemStack", (NBTBase)potionTag);
        tag.func_74778_a("itemStackName", potionName);
    }

    @Override
    public NBTTagCompound getSpecialNBT(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        NBTTagCompound specialTag = new NBTTagCompound();
        specialTag.func_74782_a("itemStack", tag.func_74781_a("itemStack"));
        specialTag.func_74778_a("itemStackName", tag.func_74779_i("itemStackName"));
        return specialTag;
    }

    @Override
    public void removeSpecialNBT(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_82580_o("itemStack");
        tag.func_82580_o("itemStackName");
    }
}

