/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier.modifiers;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.modifier.modifiers.ModifierSmelting;
import arc.bloodarsenal.registry.Constants;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ModifierAOD
extends Modifier {
    public ModifierAOD(int level) {
        super("aod", Constants.Modifiers.AOD_COUNTER.length, level, EnumModifierType.ABILITY, EnumAction.BOW);
    }

    @Override
    public void onRelease(ItemStack itemStack, World world, EntityPlayer player, int charge) {
        if (world.field_72995_K) {
            return;
        }
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack) > 0;
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack);
        int range = charge * (this.getLevel() + 1) / this.getMaxLevel();
        Item item = itemStack.func_77973_b();
        String name = (String)item.getToolClasses(itemStack).toArray()[0];
        BlockPos playerPos = player.func_180425_c();
        if (name.equals("sword")) {
            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(playerPos.func_177982_a(-range, 0, -range), playerPos.func_177982_a(range, 2 * range, range)));
            double damage = (this.getLevel() + 1) * 2;
            for (EntityLivingBase living : entities) {
                if (living == player) continue;
                living.func_70097_a(DamageSource.field_76377_j, (float)(damage * (double)((this.getLevel() + 1) / this.getMaxLevel())));
                living.func_70652_k((Entity)player);
                NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, (int)(Math.pow(charge, 3.0) * (double)(this.getLevel() + 1) / 2.7));
                ModifierTracker.getTracker(this).incrementCounter(StasisModifiable.getStasisModifiable(itemStack), 1.0);
            }
            return;
        }
        Set<Block> effectiveOn = BloodArsenalUtils.getEffectiveBlocksForTool(name);
        Set<Material> materialEffOn = BloodArsenalUtils.getEffectiveMaterialsForTool(name);
        HashMultiset drops = HashMultiset.create();
        StasisModifiable modifiable = StasisModifiable.getStasisModifiable(itemStack);
        boolean hasSmelting = modifiable.hasModifier(ModifierSmelting.class);
        for (int i = -range; i <= range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    float strengthVsBlock;
                    BlockEvent.BreakEvent event;
                    BlockPos blockPos = playerPos.func_177982_a(i, j, k);
                    BlockStack blockStack = BlockStack.getStackFromPos((World)world, (BlockPos)blockPos);
                    if (blockStack.getBlock().isAir(blockStack.getState(), (IBlockAccess)world, blockPos)) continue;
                    for (Material material : materialEffOn) {
                        if (blockStack.getState().func_185904_a() == material) continue;
                    }
                    if (!effectiveOn.contains(blockStack.getBlock()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, blockPos, blockStack.getState(), player))) || event.getResult() == Event.Result.DENY || blockStack.getBlock().func_176195_g(blockStack.getState(), world, blockPos) == -1.0f || !((strengthVsBlock = itemStack.func_150997_a(blockStack.getState())) > 1.1f) || !world.canMineBlockBody(player, blockPos)) continue;
                    if (silkTouch && blockStack.getBlock().canSilkHarvest(world, blockPos, world.func_180495_p(blockPos), player)) {
                        drops.add((Object)new ItemStackWrapper(blockStack));
                    } else if (hasSmelting) {
                        IBlockState state = world.func_180495_p(blockPos);
                        ItemStack blockItemStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
                        ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(blockItemStack);
                        if (resultStack != null && (this.getLevel() > 0 || this.getLevel() == 0 && resultStack.func_77973_b() instanceof ItemBlock)) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)resultStack));
                        }
                    } else {
                        List itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, blockPos, world.func_180495_p(blockPos), fortuneLvl);
                        for (ItemStack stacks : itemDrops) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                        }
                    }
                    world.func_175698_g(blockPos);
                    ModifierTracker.getTracker(this).incrementCounter(StasisModifiable.getStasisModifiable(itemStack), 1.0);
                }
            }
        }
        NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, (int)(Math.pow(charge, 3.0) * (double)(this.getLevel() + 1) / 2.7));
        world.func_72876_a((Entity)player, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 0.1f, false);
        BloodArsenalUtils.dropStacks((Multiset<ItemStackWrapper>)drops, world, playerPos.func_177982_a(0, 1, 0));
    }
}

