/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier;

import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import amerifrance.guideapi.api.util.TextHelper;
import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.IModifiable;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierHandler;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.modifiers.ModifierShadowTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StasisModifiable
implements IModifiable {
    public HashMap<String, ModifierTracker> trackerMap = new HashMap();
    public HashMap<String, Modifier> modifierMap = new HashMap();
    public static Map<UUID, StasisModifiable> modifiableMap = new HashMap<UUID, StasisModifiable>();

    public boolean hasModifier(Class<? extends Modifier> clazz) {
        for (Modifier modifier : this.modifierMap.values()) {
            if (modifier.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public Modifier getModifier(Class<? extends Modifier> clazz) {
        for (Modifier modifier : this.modifierMap.values()) {
            if (modifier.getClass() != clazz) continue;
            return modifier;
        }
        return Modifier.EMPTY_MODIFIER;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        HashMultimap attributeMap = HashMultimap.create();
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null) continue;
            attributeMap.putAll(modifier.getAttributeModifiers());
        }
        return attributeMap;
    }

    @Override
    public boolean canApplyModifier(Modifier modifier) {
        if (!ModifierHandler.isModifierCompatible(this.modifierMap, modifier)) {
            return false;
        }
        for (EnumModifierType modType : EnumModifierType.values()) {
            int count = 0;
            for (Modifier mod : this.modifierMap.values()) {
                if (mod.getType() != modType) continue;
                ++count;
            }
            if (count <= modType.getMax()) continue;
            return false;
        }
        String key = modifier.getUniqueIdentifier();
        if (this.modifierMap.containsKey(key)) {
            int currentLevel;
            int nextLevel = modifier.getLevel();
            return nextLevel > (currentLevel = this.modifierMap.get(key).getLevel());
        }
        return true;
    }

    @Override
    public boolean markModifierReady(ItemStack itemStack, EntityPlayer player, Modifier modifier) {
        if (modifier == Modifier.EMPTY_MODIFIER) {
            return false;
        }
        String key = modifier.getUniqueIdentifier();
        if (this.modifierMap.containsKey(key)) {
            int nextLevel = modifier.getLevel();
            int currentLevel = this.modifierMap.get(key).getLevel();
            if (!this.modifierMap.get(key).readyForUpgrade() && nextLevel > currentLevel) {
                this.modifierMap.get(key).setReadyForUpgrade(true);
                String name = this.modifierMap.get(key).hasAltName() ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
                ChatUtil.sendChat((EntityPlayer)player, (String[])new String[]{TextHelper.localizeEffect((String)"chat.bloodarsenal.modifierReady", (Object[])new Object[]{name, modifier.getLevel()})});
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean applyModifier(Modifier modifier) {
        String key = modifier.getUniqueIdentifier();
        if (this.modifierMap.containsKey(key)) {
            int currentLevel;
            int nextLevel = modifier.getLevel();
            if (nextLevel > (currentLevel = this.modifierMap.get(key).getLevel())) {
                modifier.setReadyForUpgrade(false);
                this.modifierMap.put(key, modifier);
                for (ModifierTracker tracker : this.trackerMap.values()) {
                    tracker.onModifierAdded(modifier);
                }
                return true;
            }
        } else {
            modifier.setReadyForUpgrade(false);
            this.modifierMap.put(key, modifier);
            for (ModifierTracker tracker : this.trackerMap.values()) {
                tracker.onModifierAdded(modifier);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeModifier(Modifier modifier) {
        String key = modifier.getUniqueIdentifier();
        if (this.modifierMap.containsKey(key)) {
            this.modifierMap.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(ItemStack itemStack, World world, Entity entity, int itemSlot) {
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null) continue;
            modifier.onUpdate(itemStack, world, entity, itemSlot);
        }
        for (Map.Entry<String, Object> entry : this.trackerMap.entrySet()) {
            ModifierTracker tracker = (ModifierTracker)entry.getValue();
            if (tracker == null || !tracker.onTick(this) || !(entity instanceof EntityPlayer)) continue;
            this.markModifierReady(itemStack, (EntityPlayer)entity, tracker.getNextModifier(this.modifierMap));
        }
    }

    public void onSpecialUpdate(ItemStack itemStack, World world, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<String, ModifierTracker> entry : this.trackerMap.entrySet()) {
            ModifierTracker tracker = entry.getValue();
            if (tracker == null || !(tracker.getModifier() instanceof ModifierShadowTool) || !tracker.onTick(this) || !(entity instanceof EntityPlayer)) continue;
            this.markModifierReady(itemStack, (EntityPlayer)entity, tracker.getNextModifier(this.modifierMap));
        }
    }

    @Override
    public void hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null) continue;
            modifier.hitEntity(itemStack, target, attacker);
        }
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null) continue;
            modifier.onBlockDestroyed(itemStack, world, state, pos, player);
        }
    }

    @Override
    public void onRelease(ItemStack itemStack, World world, EntityPlayer player, int charge) {
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null || modifier.getType() != EnumModifierType.ABILITY) continue;
            modifier.onRelease(itemStack, world, player, charge);
        }
    }

    @Override
    public void onRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            Modifier modifier = entry.getValue();
            if (modifier == null || modifier.getType() != EnumModifierType.ABILITY) continue;
            modifier.onRightClick(itemStack, world, player);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        String key;
        NBTTagList modTags = tag.func_150295_c("modifiers", 10);
        if (modTags != null) {
            for (int i = 0; i < modTags.func_74745_c(); ++i) {
                NBTTagCompound nbtTag;
                boolean readyForUpgrade;
                int level;
                NBTTagCompound modTag = modTags.func_150305_b(i);
                key = modTag.func_74779_i("Key");
                Modifier modifier = ModifierHandler.generateModifierFromKey(key, level = modTag.func_74762_e("Level"), readyForUpgrade = modTag.func_74767_n("ReadyToUpgrade"), nbtTag = modTag.func_74775_l("modifier"));
                if (modifier != null) {
                    this.modifierMap.put(key, modifier);
                    continue;
                }
                modTags.func_74744_a(i);
            }
        }
        for (ModifierTracker tracker : ModifierHandler.trackers) {
            try {
                key = tracker.getUniqueIdentifier();
                NBTTagCompound trackerTag = tag.func_74775_l(key);
                if (!trackerTag.func_82582_d()) {
                    tracker.readFromNBT(trackerTag);
                }
                this.trackerMap.put(key, tracker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean forceWrite) {
        NBTTagList tags = new NBTTagList();
        for (Map.Entry<String, Modifier> entry : this.modifierMap.entrySet()) {
            NBTTagCompound modifierTag = new NBTTagCompound();
            Modifier modifier = entry.getValue();
            NBTTagCompound nbtTag = new NBTTagCompound();
            modifier.writeToNBT(nbtTag);
            modifierTag.func_74778_a("Key", modifier.getUniqueIdentifier());
            modifierTag.func_74768_a("Level", modifier.getLevel());
            modifierTag.func_74757_a("ReadyToUpgrade", modifier.readyForUpgrade());
            modifierTag.func_74782_a("modifier", (NBTBase)nbtTag);
            tags.func_74742_a((NBTBase)modifierTag);
        }
        tag.func_74782_a("modifiers", (NBTBase)tags);
        for (Map.Entry<String, Object> entry : this.trackerMap.entrySet()) {
            ModifierTracker tracker = (ModifierTracker)entry.getValue();
            if (tracker == null) continue;
            String key = tracker.getUniqueIdentifier();
            if (!forceWrite && !tracker.isDirty()) continue;
            NBTTagCompound trackerTag = new NBTTagCompound();
            tracker.writeToNBT(trackerTag);
            tag.func_74782_a(key, (NBTBase)trackerTag);
            tracker.resetDirty();
        }
    }

    @Override
    public void writeDirtyToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, false);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, true);
    }

    public static StasisModifiable getModFromNBT(ItemStack itemStack) {
        NBTTagCompound tag = StasisModifiable.getNBTTag(itemStack);
        StasisModifiable modifiable = new StasisModifiable();
        modifiable.readFromNBT(tag);
        return modifiable;
    }

    public static void setStasisModifiable(ItemStack itemStack, StasisModifiable modifiable, boolean forceWrite) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!forceWrite) {
            tag = StasisModifiable.getNBTTag(itemStack);
            modifiable.writeDirtyToNBT(tag);
        } else {
            modifiable.writeDirtyToNBT(tag);
        }
        StasisModifiable.setNBTTag(itemStack, tag);
    }

    public static NBTTagCompound getNBTTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74775_l("stasisModifiers");
    }

    public static void setNBTTag(ItemStack stack, NBTTagCompound tag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("stasisModifiers", (NBTBase)tag);
    }

    public static Modifier getModifier(String uniqueIdentifier, ItemStack itemStack) {
        if (!StasisModifiable.hasModifiable(itemStack)) {
            StasisModifiable.setStasisModifiable(itemStack, StasisModifiable.getModFromNBT(itemStack));
        }
        StasisModifiable modifiable = StasisModifiable.getStasisModifiable(itemStack);
        for (Map.Entry<String, Modifier> entry : modifiable.modifierMap.entrySet()) {
            if (!entry.getKey().equals(uniqueIdentifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Modifier getModifierFromNBT(String uniqueIdentifier, ItemStack itemStack) {
        StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
        for (Map.Entry<String, Modifier> entry : modifiable.modifierMap.entrySet()) {
            if (!entry.getKey().equals(uniqueIdentifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean hasModifiable(ItemStack itemStack) {
        UUID uuid = Utils.getUUID((ItemStack)itemStack);
        return uuid != null && modifiableMap.containsKey(uuid);
    }

    public static StasisModifiable getStasisModifiable(ItemStack itemStack) {
        return modifiableMap.getOrDefault(Utils.getUUID((ItemStack)itemStack), null);
    }

    public static void setStasisModifiable(ItemStack itemStack, StasisModifiable modifiable) {
        if (!Utils.hasUUID((ItemStack)itemStack)) {
            Utils.setUUID((ItemStack)itemStack);
        }
        modifiableMap.put(Utils.getUUID((ItemStack)itemStack), modifiable);
    }

    public static boolean hasModifier(String id, ItemStack itemStack) {
        if (!StasisModifiable.hasModifiable(itemStack)) {
            StasisModifiable.setStasisModifiable(itemStack, StasisModifiable.getModFromNBT(itemStack));
        }
        return StasisModifiable.getStasisModifiable((ItemStack)itemStack).modifierMap.containsKey(id);
    }

    public static void invokeModMethod(ItemStack itemStack, Method method, Object ... args) {
        if (!StasisModifiable.hasModifiable(itemStack)) {
            StasisModifiable.setStasisModifiable(itemStack, StasisModifiable.getModFromNBT(itemStack));
        }
        StasisModifiable modifiable = StasisModifiable.getStasisModifiable(itemStack);
        try {
            method.invoke((Object)modifiable, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StasisModifiable.setStasisModifiable(itemStack, modifiable, false);
    }
}

