/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier;

import WayofTime.bloodmagic.util.Utils;
import arc.bloodarsenal.modifier.IModifiable;
import arc.bloodarsenal.modifier.Modifier;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class ModifierTracker {
    public static HashMap<String, ModifierTracker> trackerMap = new HashMap();
    public double counter = 0.0;
    public static HashMap<IModifiable, HashMap<Class<? extends Modifier>, Double>> changeMap = new HashMap();
    public final int[] COUNTERS_NEEDED;
    private boolean isDirty = false;
    protected String name;
    private final Modifier modifier;

    private ModifierTracker(Modifier modifier, int[] countersNeeded) {
        this.modifier = modifier;
        this.COUNTERS_NEEDED = countersNeeded;
    }

    public static ModifierTracker newTracker(Modifier modifier, int[] countersNeeded) {
        ModifierTracker tracker = new ModifierTracker(modifier, countersNeeded);
        trackerMap.put(modifier.getUniqueIdentifier(), tracker);
        return tracker;
    }

    public static ModifierTracker getTracker(Modifier modifier) {
        return trackerMap.getOrDefault(modifier.getUniqueIdentifier(), null);
    }

    public static ModifierTracker getTracker(Class<? extends Modifier> clazz) {
        String name = "";
        try {
            Method method = clazz.getDeclaredMethod("getUniqueIdentifier", new Class[0]);
            name = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trackerMap.getOrDefault(name, null);
    }

    protected String getName() {
        return this.modifier.getName();
    }

    public String getUniqueIdentifier() {
        return "bloodarsenal.tracker." + this.getName();
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void resetTracker() {
        this.counter = 0.0;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.counter = tag.func_74769_h(this.getUniqueIdentifier());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a(this.getUniqueIdentifier(), this.counter);
    }

    public boolean onTick(IModifiable modifiable) {
        double change;
        if (changeMap.containsKey(modifiable) && changeMap.get(modifiable).containsKey(this.modifier.getClass()) && (change = Math.abs(changeMap.get(modifiable).get(this.modifier.getClass()))) > 0.0) {
            this.counter += Math.abs(changeMap.get(modifiable).get(this.modifier.getClass()));
            HashMap<Class<? extends Modifier>, Double> lol = changeMap.get(modifiable);
            lol.put(this.modifier.getClass(), 0.0);
            changeMap.put(modifiable, lol);
            this.markDirty();
            return true;
        }
        return false;
    }

    public Modifier getNextModifier(HashMap<String, Modifier> modifierMap) {
        Modifier modifier = Modifier.EMPTY_MODIFIER;
        for (Map.Entry<String, Modifier> entry : modifierMap.entrySet()) {
            if (!entry.getValue().getClass().isInstance(this.modifier)) continue;
            modifier = entry.getValue();
        }
        if (modifier != Modifier.EMPTY_MODIFIER) {
            for (int i = this.COUNTERS_NEEDED.length - 1; i > 0; --i) {
                if (!(this.counter >= (double)this.COUNTERS_NEEDED[i])) continue;
                return modifier.getLevel() < i ? this.modifier.newCopy(i) : modifier;
            }
        }
        return modifier;
    }

    public double getProgress(int currentLevel) {
        return Utils.calculateStandardProgress((Number)this.counter, (int[])this.COUNTERS_NEEDED, (int)currentLevel);
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void markDirty() {
        this.isDirty = true;
    }

    public final void resetDirty() {
        this.isDirty = false;
    }

    public boolean providesModifier(String key) {
        return key.equals(this.getUniqueIdentifier());
    }

    public void onModifierAdded(Modifier modifier) {
        int level;
        if (modifier.getClass().isInstance(this.modifier) && (level = modifier.getLevel()) < this.COUNTERS_NEEDED.length) {
            this.counter = Math.max(this.counter, (double)this.COUNTERS_NEEDED[level]);
            this.markDirty();
        }
    }

    public void incrementCounter(IModifiable modifiable, double increment) {
        if (changeMap.containsKey(modifiable) && changeMap.get(modifiable).containsKey(this.modifier.getClass())) {
            HashMap<Class<? extends Modifier>, Double> lol = changeMap.get(modifiable);
            lol.put(this.modifier.getClass(), changeMap.get(modifiable).get(this.modifier.getClass()) + increment);
            changeMap.put(modifiable, lol);
        } else {
            HashMap lol = new HashMap();
            lol.put(this.modifier.getClass(), increment);
            changeMap.put(modifiable, lol);
        }
    }

    public static void incrementCounter(IModifiable modifiable, Class<? extends Modifier> clazz, double increment) {
        if (changeMap.containsKey(modifiable) && changeMap.get(modifiable).containsKey(clazz)) {
            HashMap<Class<? extends Modifier>, Double> lol = changeMap.get(modifiable);
            lol.put(clazz, changeMap.get(modifiable).get(clazz) + increment);
            changeMap.put(modifiable, lol);
        } else {
            HashMap<Class<? extends Modifier>, Double> lol = new HashMap<Class<? extends Modifier>, Double>();
            lol.put(clazz, increment);
            changeMap.put(modifiable, lol);
        }
    }
}

