/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.modifier;

import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class ModifierHandler {
    public static List<ModifierTracker> trackers = new ArrayList<ModifierTracker>();
    public static HashMap<String, Class<? extends Modifier>> modifierMap = new HashMap();
    public static HashMap<String, Constructor<? extends Modifier>> modifierConstructorMap = new HashMap();
    public static Set<Pair<EnumModifierType, Set<Modifier>>> incompatibleModifiersMap = new HashSet<Pair<EnumModifierType, Set<Modifier>>>();
    public static HashMap<String, Integer> modifierMaxLevelMap = new HashMap();

    public static void registerTracker(ModifierTracker tracker) {
        if (trackers.contains(tracker)) {
            BloodArsenal.INSTANCE.getLogger().error("You utter dimwit. I'm not even going to provide you with an informative error.", new Object[0]);
        }
        trackers.add(tracker);
    }

    public static Modifier registerModifier(Modifier modifier) {
        Class<?> clazz = modifier.getClass();
        modifierMap.put(modifier.getUniqueIdentifier(), clazz);
        modifierMaxLevelMap.put(modifier.getUniqueIdentifier(), modifier.getMaxLevel());
        try {
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
            if (constructor == null) {
                BloodArsenal.INSTANCE.getLogger().error("Error adding soul modifier {} since it doesn't have a frickin valid constructor dummy.", new Object[]{modifier.getUniqueIdentifier()});
            } else {
                modifierConstructorMap.put(modifier.getUniqueIdentifier(), constructor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifier;
    }

    public static void registerIncompatibleModifiers(EnumModifierType type, Modifier ... modifiers) {
        HashSet<Modifier> modList = new HashSet<Modifier>();
        for (Modifier modifier : modifiers) {
            if (type != modifier.getType()) {
                BloodArsenal.INSTANCE.getLogger().error("Error registering incompatible modifiers since {} does not match modifier type ya idiot.", new Object[]{modifier.getUniqueIdentifier()});
                continue;
            }
            modList.add(modifier);
        }
        incompatibleModifiersMap.add((Pair<EnumModifierType, Set<Modifier>>)Pair.of((Object)((Object)type), modList));
    }

    public static Modifier generateModifierFromKey(String key, int level, boolean readyForUpgrade) {
        return ModifierHandler.generateModifierFromKey(key, level, readyForUpgrade, null);
    }

    public static Modifier generateModifierFromKey(String key, int level, boolean readyForUpgrade, NBTTagCompound tag) {
        Constructor<? extends Modifier> constructor = modifierConstructorMap.get(key);
        if (constructor != null) {
            try {
                Modifier modifier = constructor.newInstance(level);
                if (tag != null) {
                    modifier.readFromNBT(tag);
                }
                modifier.setReadyForUpgrade(readyForUpgrade);
                return modifier;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isModifierCompatible(Map<String, Modifier> modifierMap, Modifier modifier) {
        for (Pair<EnumModifierType, Set<Modifier>> pair : incompatibleModifiersMap) {
            if (pair.getKey() != modifier.getType() || ((Set)pair.getValue()).isEmpty() || !((Set)pair.getValue()).contains(modifier)) continue;
            for (Modifier incompatMod : (Set)pair.getValue()) {
                if (modifier.getUniqueIdentifier().equals(incompatMod.getUniqueIdentifier()) || !modifierMap.containsKey(incompatMod.getUniqueIdentifier())) continue;
                return false;
            }
        }
        return true;
    }
}

