/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.item.tool;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import arc.bloodarsenal.client.mesh.CustomMeshDefinitionActivatable;
import arc.bloodarsenal.item.tool.ItemBoundTool;
import arc.bloodarsenal.registry.Constants;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundSickle
extends ItemBoundTool {
    private final int RANGE = 3;

    public ItemBoundSickle() {
        super("sickle", 5.0f, Constants.Item.SICKLE_EFFECTIVE_ON);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() instanceof IPlantable || state.func_177230_c() instanceof IShearable;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        return state.func_177230_c() instanceof IPlantable ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack) > 0;
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack);
        if (!world.field_72995_K && this.func_150897_b(state)) {
            Iterable positions = BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-3, -3, -3), (BlockPos)pos.func_177982_a(3, 3, 3));
            HashMultiset drops = HashMultiset.create();
            for (BlockPos.MutableBlockPos blockPos : positions) {
                List itemDrops;
                float strengthVsBlock;
                BlockEvent.BreakEvent event;
                BlockStack blockStack = BlockStack.getStackFromPos((World)world, (BlockPos)blockPos);
                if (blockStack.getBlock().isAir(blockStack.getState(), (IBlockAccess)world, (BlockPos)blockPos) || !Constants.Item.SICKLE_EFFECTIVE_ON.contains(blockStack.getBlock()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, (BlockPos)blockPos, blockStack.getState(), player))) || event.getResult() == Event.Result.DENY || blockStack.getBlock().func_176195_g(blockStack.getState(), world, (BlockPos)blockPos) == -1.0f || !((strengthVsBlock = this.func_150893_a(itemStack, blockStack.getState())) > 1.1f) || !world.canMineBlockBody(player, (BlockPos)blockPos)) continue;
                if (silkTouch) {
                    if (blockStack.getBlock() instanceof IShearable) {
                        for (ItemStack stack : ((IShearable)blockStack.getBlock()).onSheared(itemStack, (IBlockAccess)world, (BlockPos)blockPos, fortuneLvl)) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stack));
                        }
                    } else if (blockStack.getBlock().canSilkHarvest(world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), player)) {
                        drops.add((Object)new ItemStackWrapper(blockStack.getBlock()));
                    } else {
                        itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), fortuneLvl);
                        for (ItemStack stacks : itemDrops) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                        }
                    }
                } else {
                    itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), fortuneLvl);
                    for (ItemStack stacks : itemDrops) {
                        drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                    }
                }
                world.func_175698_g((BlockPos)blockPos);
                BloodArsenalUtils.dropStacks((Multiset<ItemStackWrapper>)drops, world, (BlockPos)blockPos);
                drops.clear();
            }
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    @Override
    protected void onBoundRelease(ItemStack itemStack, World world, EntityPlayer player, int charge) {
        if (world.field_72995_K) {
            return;
        }
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack) > 0;
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack);
        int range = charge / 3;
        HashMultiset drops = HashMultiset.create();
        BlockPos playerPos = player.func_180425_c();
        for (int i = -range; i <= range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    float strengthVsBlock;
                    BlockEvent.BreakEvent event;
                    BlockPos blockPos = playerPos.func_177982_a(i, j, k);
                    BlockStack blockStack = BlockStack.getStackFromPos((World)world, (BlockPos)blockPos);
                    if (blockStack.getBlock().isAir(blockStack.getState(), (IBlockAccess)world, blockPos) || !Constants.Item.SICKLE_EFFECTIVE_ON.contains(blockStack.getBlock()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, blockPos, blockStack.getState(), player))) || event.getResult() == Event.Result.DENY || blockStack.getBlock().func_176195_g(blockStack.getState(), world, blockPos) == -1.0f || !((strengthVsBlock = this.func_150893_a(itemStack, blockStack.getState())) > 1.1f) || !world.canMineBlockBody(player, blockPos)) continue;
                    if (silkTouch) {
                        if (blockStack.getBlock() instanceof IShearable) {
                            for (ItemStack stack : ((IShearable)blockStack.getBlock()).onSheared(itemStack, (IBlockAccess)world, blockPos, fortuneLvl)) {
                                drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stack));
                            }
                        } else if (blockStack.getBlock().canSilkHarvest(world, blockPos, world.func_180495_p(blockPos), player)) {
                            drops.add((Object)new ItemStackWrapper(blockStack.getBlock()));
                        }
                    } else {
                        List itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, blockPos, world.func_180495_p(blockPos), fortuneLvl);
                        for (ItemStack stacks : itemDrops) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                        }
                    }
                    world.func_175698_g(blockPos);
                }
            }
        }
        NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, (int)((double)(charge * charge * charge) / 2.7));
        world.func_72876_a((Entity)player, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 0.1f, false);
        BloodArsenalUtils.dropStacks((Multiset<ItemStackWrapper>)drops, world, playerPos.func_177982_a(0, 1, 0));
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)itemStack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getActivated(stack) ? 6.0 : 2.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("ItemBoundSickle");
    }
}

