/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.item.tool;

import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ItemBloodInfusedTool
extends ItemTool
implements IVariantProvider {
    protected final String tooltipBase;
    private final int enchantibility;
    private final int repairUpdate;
    private final int repairCost;

    public ItemBloodInfusedTool(String type, Item.ToolMaterial toolMaterial, String name, float damage, Set<Block> effectiveBlocks, int enchantibility, int repairUpdate, int repairCost) {
        super(damage, -2.8f, toolMaterial, effectiveBlocks);
        this.func_77655_b("bloodarsenal.bloodInfused" + type + "." + name);
        this.func_77637_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.setHarvestLevel(name, toolMaterial == ModItems.BLOOD_INFUSED_IRON ? 3 : 1);
        this.tooltipBase = "tooltip.bloodarsenal.bloodInfused" + type + "." + name + ".";
        this.enchantibility = enchantibility;
        this.repairUpdate = repairUpdate;
        this.repairCost = repairCost;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77952_i() > 0 && world.func_72820_D() % (long)this.repairUpdate == 0L && field_77697_d.nextBoolean() && entity instanceof EntityPlayer) {
            NBTTagList enchants;
            int cost = this.repairCost;
            if (stack.func_77948_v() && (enchants = stack.func_77986_q()) != null && enchants.func_74745_c() > 0) {
                for (int i = 0; i <= enchants.func_74745_c(); ++i) {
                    NBTTagCompound enchant = enchants.func_150305_b(i);
                    short lvl = enchant.func_74765_d("lvl");
                    cost *= this.repairCost / 10 * lvl;
                }
            }
            NetworkHelper.getSoulNetwork((EntityPlayer)((EntityPlayer)entity)).syphonAndDamage((EntityPlayer)entity, cost);
            stack.func_77964_b(stack.func_77952_i() - 2);
        }
    }

    public int func_77619_b() {
        return this.enchantibility;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        if (I18n.func_188566_a((String)(this.tooltipBase + "desc"))) {
            tooltip.add(TextHelper.localizeEffect((String)(this.tooltipBase + "desc"), (Object[])new Object[0]));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"normal"));
        return ret;
    }

    public static class Iron
    extends ItemBloodInfusedTool {
        public Iron(String name, float damage, Set<Block> effectiveBlocks) {
            super("Iron", ModItems.BLOOD_INFUSED_IRON, name, damage, effectiveBlocks, 18, ConfigHandler.bloodInfusedWoodenToolsRepairUpdate, ConfigHandler.bloodInfusedWoodenToolsRepairCost);
        }

        public EnumRarity func_77613_e(ItemStack stack) {
            return EnumRarity.UNCOMMON;
        }
    }

    public static class Wooden
    extends ItemBloodInfusedTool {
        public Wooden(String name, float damage, Set<Block> effectiveBlocks) {
            super("Wooden", ModItems.BLOOD_INFUSED_WOOD, name, damage, effectiveBlocks, 18, ConfigHandler.bloodInfusedWoodenToolsRepairUpdate, ConfigHandler.bloodInfusedWoodenToolsRepairCost);
        }
    }
}

