/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.item.tool;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import arc.bloodarsenal.item.tool.ItemBloodInfusedTool;
import arc.bloodarsenal.registry.Constants;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemBloodInfusedIronSickle
extends ItemBloodInfusedTool.Iron {
    private final int RANGE = 2;

    public ItemBloodInfusedIronSickle() {
        super("sickle", 2.0f, Constants.Item.SICKLE_EFFECTIVE_ON);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemStack) > 0;
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack);
        if (!world.field_72995_K && this.func_150897_b(state)) {
            Iterable positions = BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2));
            HashMultiset drops = HashMultiset.create();
            for (BlockPos.MutableBlockPos blockPos : positions) {
                List itemDrops;
                float strengthVsBlock;
                BlockEvent.BreakEvent event;
                BlockStack blockStack = BlockStack.getStackFromPos((World)world, (BlockPos)blockPos);
                if (blockStack.getBlock().isAir(blockStack.getState(), (IBlockAccess)world, (BlockPos)blockPos) || !Constants.Item.SICKLE_EFFECTIVE_ON.contains(blockStack.getBlock()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, (BlockPos)blockPos, blockStack.getState(), player))) || event.getResult() == Event.Result.DENY || blockStack.getBlock().func_176195_g(blockStack.getState(), world, (BlockPos)blockPos) == -1.0f || !((strengthVsBlock = this.func_150893_a(itemStack, blockStack.getState())) > 1.1f) || !world.canMineBlockBody(player, (BlockPos)blockPos)) continue;
                if (silkTouch) {
                    if (blockStack.getBlock() instanceof IShearable) {
                        for (ItemStack stack : ((IShearable)blockStack.getBlock()).onSheared(itemStack, (IBlockAccess)world, (BlockPos)blockPos, fortuneLvl)) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stack));
                        }
                    } else if (blockStack.getBlock().canSilkHarvest(world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), player)) {
                        drops.add((Object)new ItemStackWrapper(blockStack.getBlock()));
                    } else {
                        itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), fortuneLvl);
                        for (ItemStack stacks : itemDrops) {
                            drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                        }
                    }
                } else {
                    itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, (BlockPos)blockPos, world.func_180495_p((BlockPos)blockPos), fortuneLvl);
                    for (ItemStack stacks : itemDrops) {
                        drops.add((Object)ItemStackWrapper.getHolder((ItemStack)stacks));
                    }
                }
                world.func_175698_g((BlockPos)blockPos);
                BloodArsenalUtils.dropStacks((Multiset<ItemStackWrapper>)drops, world, (BlockPos)blockPos);
                drops.clear();
            }
        }
        return true;
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)itemStack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        BloodArsenalUtils.tillBlock(itemStack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.3, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -1.2, 0));
        }
        return multimap;
    }
}

