/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.item.stasis;

import WayofTime.bloodmagic.api.event.BoundToolEvent;
import WayofTime.bloodmagic.api.iface.IActivatable;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.modifier.EnumModifierType;
import arc.bloodarsenal.modifier.IModifiableItem;
import arc.bloodarsenal.modifier.Modifier;
import arc.bloodarsenal.modifier.ModifierTracker;
import arc.bloodarsenal.modifier.StasisModifiable;
import arc.bloodarsenal.modifier.modifiers.ModifierShadowTool;
import arc.bloodarsenal.registry.ModItems;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;

public abstract class ItemStasisTool
extends ItemTool
implements IBindable,
IActivatable,
IModifiableItem,
IMeshProvider {
    protected final String tooltipBase;
    public Map<ItemStack, Boolean> heldDownMap = new HashMap<ItemStack, Boolean>();
    public Map<ItemStack, Integer> heldDownCountMap = new HashMap<ItemStack, Integer>();
    public final int CHARGE_TIME = 30;
    public int cost = 5;
    private String name;

    public ItemStasisTool(String name, float damage) {
        super(damage, -3.2f, ModItems.STASIS, BloodArsenalUtils.getEffectiveBlocksForTool(name));
        this.func_77655_b("bloodarsenal.stasis." + name);
        this.func_77637_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.setHarvestLevel(name, 4);
        this.name = name;
        this.tooltipBase = "tooltip.bloodarsenal.stasis." + name + ".";
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (Strings.isNullOrEmpty((String)this.getOwnerUUID(itemStack))) {
            this.setActivatedState(itemStack, false);
            return;
        }
        if (entity instanceof EntityPlayer && this.getActivated(itemStack) && isSelected && this.getBeingHeldDown(itemStack) && itemStack == ((EntityPlayer)entity).func_184607_cu()) {
            EntityPlayer player = (EntityPlayer)entity;
            this.setHeldDownCount(itemStack, Math.min(player.func_184605_cv(), 30));
        } else if (!isSelected) {
            this.setBeingHeldDown(itemStack, false);
        }
        if (entity instanceof EntityPlayer) {
            if (this.getActivated(itemStack)) {
                try {
                    StasisModifiable.invokeModMethod(itemStack, StasisModifiable.class.getDeclaredMethod("onUpdate", ItemStack.class, World.class, Entity.class, Integer.TYPE), itemStack, world, entity, itemSlot);
                }
                catch (Exception player) {
                    // empty catch block
                }
                if (world.func_82737_E() % 80L == 0L) {
                    NetworkHelper.getSoulNetwork((String)this.getOwnerUUID(itemStack)).syphonAndDamage((EntityPlayer)entity, this.cost);
                }
            } else {
                StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
                if (modifiable != null && modifiable.hasModifier(ModifierShadowTool.class)) {
                    modifiable.onSpecialUpdate(itemStack, world, entity);
                }
            }
        }
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.getActivated(itemStack)) {
            try {
                StasisModifiable.invokeModMethod(itemStack, StasisModifiable.class.getDeclaredMethod("hitEntity", ItemStack.class, EntityLivingBase.class, EntityLivingBase.class), itemStack, target, attacker);
            }
            catch (Exception exception) {}
        } else {
            StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
            if (modifiable != null && modifiable.hasModifier(ModifierShadowTool.class)) {
                ModifierTracker.getTracker(ModifierShadowTool.class).incrementCounter(modifiable, 1.0);
            }
        }
        return true;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLivingBase) {
        if (!world.field_72995_K) {
            if (this.getActivated(itemStack)) {
                if (entityLivingBase instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entityLivingBase;
                    try {
                        StasisModifiable.invokeModMethod(itemStack, StasisModifiable.class.getDeclaredMethod("onBlockDestroyed", ItemStack.class, World.class, IBlockState.class, BlockPos.class, EntityPlayer.class), itemStack, world, state, pos, player);
                    }
                    catch (Exception exception) {}
                }
            } else {
                StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
                if (modifiable != null && modifiable.hasModifier(ModifierShadowTool.class)) {
                    ModifierTracker.getTracker(ModifierShadowTool.class).incrementCounter(modifiable, 1.0);
                }
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            this.setActivatedState(itemStack, !this.getActivated(itemStack));
        }
        if (!player.func_70093_af() && this.getActivated(itemStack)) {
            StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
            Modifier modifier = Modifier.EMPTY_MODIFIER;
            for (Map.Entry<String, Modifier> entry : modifiable.modifierMap.entrySet()) {
                if (entry.getValue().getType() != EnumModifierType.ABILITY) continue;
                modifier = entry.getValue();
                break;
            }
            if (modifier != Modifier.EMPTY_MODIFIER) {
                if (modifier.getAction() == EnumAction.BOW) {
                    BoundToolEvent.Charge event = new BoundToolEvent.Charge(player, itemStack);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)event.result);
                    }
                    player.func_184598_c(hand);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
                }
                if (!world.field_72995_K) {
                    try {
                        StasisModifiable.invokeModMethod(itemStack, StasisModifiable.class.getDeclaredMethod("onRightClick", ItemStack.class, World.class, EntityPlayer.class), itemStack, world, player);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return super.func_77659_a(itemStack, world, player, hand);
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entityLiving, int timeLeft) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && !(player = (EntityPlayer)entityLiving).func_70093_af() && this.getActivated(itemStack)) {
            int i = this.func_77626_a(itemStack) - timeLeft;
            BoundToolEvent.Release event = new BoundToolEvent.Release(player, itemStack, i);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            i = event.charge;
            try {
                StasisModifiable.invokeModMethod(itemStack, StasisModifiable.class.getDeclaredMethod("onRelease", ItemStack.class, World.class, EntityPlayer.class, Integer.TYPE), itemStack, world, player, Math.min(i, 30));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBeingHeldDown(itemStack, false);
        }
    }

    public float func_150893_a(ItemStack itemStack, IBlockState state) {
        StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
        return this.getActivated(itemStack) ? this.func_150913_i().func_77998_b() : (modifiable.hasModifier(ModifierShadowTool.class) ? this.field_77864_a * (((float)modifiable.getModifier(ModifierShadowTool.class).getLevel() + 2.0f) / 6.0f) : 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) || slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(Utils.setUnbreakable((ItemStack)new ItemStack(itemIn)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42)) {
            StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
            for (EnumModifierType type : EnumModifierType.values()) {
                tooltip.add(TextHelper.localize((String)("tooltip.bloodarsenal.modifierType." + WordUtils.swapCase((String)type.toString())), (Object[])new Object[0]));
                for (Map.Entry<String, Modifier> entry : modifiable.modifierMap.entrySet()) {
                    Modifier modifier = entry.getValue();
                    if (modifier == null || modifier.getType() != type) continue;
                    String name = modifier.hasAltName() ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
                    tooltip.add(" -" + TextHelper.localize((String)"tooltip.bloodarsenal.modifier.level", (Object[])new Object[]{name, modifier.getLevel() + 1, modifier.readyForUpgrade() ? "+" : ""}));
                }
            }
        } else {
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.holdShift", (Object[])new Object[0]));
        }
        super.func_77624_a(itemStack, player, tooltip, advanced);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
        Modifier modifier = Modifier.EMPTY_MODIFIER;
        for (Map.Entry<String, Modifier> entry : modifiable.modifierMap.entrySet()) {
            if (entry.getValue().getType() != EnumModifierType.ABILITY) continue;
            modifier = entry.getValue();
        }
        return modifier != Modifier.EMPTY_MODIFIER ? modifier.getAction() : EnumAction.NONE;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)this.name);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.getActivated(itemStack) && this.getBeingHeldDown(itemStack);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return (double)(-Math.min(this.getHeldDownCount(itemStack), 30)) / 30.0 + 1.0;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            if (this.getActivated(itemStack)) {
                return StasisModifiable.getModFromNBT(itemStack).getAttributeModifiers();
            }
            StasisModifiable modifiable = StasisModifiable.getModFromNBT(itemStack);
            Multimap<String, AttributeModifier> map = modifiable.getAttributeModifiers();
            boolean hasShadow = modifiable.hasModifier(ModifierShadowTool.class);
            if (hasShadow) {
                Modifier modifier = modifiable.getModifier(ModifierShadowTool.class);
                map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.7 * (double)(modifier.getLevel() + 1) / 5.0, 0));
                map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5 * (double)(modifier.getLevel() + 1) / 5.0, 0));
            } else {
                map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
                map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.8, 0));
            }
            return map;
        }
        return super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("active=true");
        ret.add("active=false");
        return ret;
    }

    protected int getHeldDownCount(ItemStack itemStack) {
        if (!this.heldDownCountMap.containsKey(itemStack)) {
            return 0;
        }
        return this.heldDownCountMap.get(itemStack);
    }

    protected void setHeldDownCount(ItemStack itemStack, int count) {
        this.heldDownCountMap.put(itemStack, count);
    }

    protected boolean getBeingHeldDown(ItemStack itemStack) {
        if (!this.heldDownMap.containsKey(itemStack)) {
            return false;
        }
        return this.heldDownMap.get(itemStack);
    }

    protected void setBeingHeldDown(ItemStack itemStack, boolean heldDown) {
        this.heldDownMap.put(itemStack, heldDown);
    }

    public String getOwnerName(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74779_i("ownerNAME") : null;
    }

    public String getOwnerUUID(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74779_i("ownerUUID") : null;
    }

    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public boolean getActivated(ItemStack stack) {
        return stack != null && NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74767_n("activated");
    }

    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (stack != null) {
            NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return null;
    }
}

