/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.item.sigil;

import WayofTime.bloodmagic.api.iface.IAltarReader;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.client.key.IKeybindable;
import WayofTime.bloodmagic.client.key.KeyBindings;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.BloodArsenal;
import arc.bloodarsenal.item.sigil.ItemSigilBase;
import arc.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSigilAugmentedHolding
extends ItemSigilBase
implements IKeybindable,
IAltarReader {
    public static final int INVENTORY_SIZE = 9;

    public ItemSigilAugmentedHolding() {
        super("augmentedHolding");
    }

    public void onKeyPressed(ItemStack stack, EntityPlayer player, KeyBindings key, boolean showInChat) {
        if (stack != null && stack == player.func_184614_ca() && stack.func_77973_b() instanceof ItemSigilAugmentedHolding && key.equals((Object)KeyBindings.OPEN_HOLDING)) {
            Utils.setUUID((ItemStack)stack);
            player.openGui((Object)BloodArsenal.INSTANCE, 0, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        int currentSlot;
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack item = inv.get(currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack));
        if (item == null) {
            return displayName;
        }
        return TextHelper.localizeEffect((String)"item.bloodmagic.sigil.holding.display", (Object[])new Object[]{displayName, item.func_82833_r()});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        tooltip.add(TextHelper.localizeEffect((String)"tooltip.BloodMagic.sigil.holding.press", (Object[])new Object[]{KeyBindings.OPEN_HOLDING.getKey().getDisplayName()}));
        if (!stack.func_77942_o()) {
            return;
        }
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        ItemStack item = inv.get(currentSlot);
        for (int i = 0; i < 9; ++i) {
            ItemStack invStack = inv.get(i);
            if (invStack == null) continue;
            if (item != null && invStack == item) {
                tooltip.add(TextHelper.localizeEffect((String)"tooltip.BloodMagic.sigil.holding.sigilInSlot", (Object[])new Object[]{i + 1, "&o&n" + invStack.func_82833_r()}));
                continue;
            }
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.BloodMagic.sigil.holding.sigilInSlot", (Object[])new Object[]{i + 1, invStack.func_82833_r()}));
        }
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return EnumActionResult.FAIL;
        }
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing == null || Strings.isNullOrEmpty((String)((IBindable)itemUsing.func_77973_b()).getOwnerUUID(itemUsing))) {
            return EnumActionResult.PASS;
        }
        EnumActionResult result = itemUsing.func_77973_b().func_180614_a(itemStack, player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        this.saveInventory(stack, inv);
        return result;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing != null || Strings.isNullOrEmpty((String)((IBindable)itemUsing.func_77973_b()).getOwnerUUID(itemUsing))) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        itemUsing.func_77973_b().func_77659_a(itemStack, world, player, hand);
        this.saveInventory(stack, inv);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void saveInventory(ItemStack itemStack, List<ItemStack> inventory) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (inventory.get(i) == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory.get(i).func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Items", (NBTBase)itemList);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!itemStack.func_77942_o()) {
            this.tickInternalInventory(itemStack, world, entity, itemSlot, isSelected);
        }
    }

    public void tickInternalInventory(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(itemStack);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inv.get(i);
            if (stack == null) continue;
            stack.func_77973_b().func_77663_a(stack, world, entity, itemSlot, isSelected);
        }
    }

    private static void initModeTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            NBTHelper.checkNBT((ItemStack)stack);
            stack.func_77978_p().func_74768_a("currentSigil", 9);
        }
    }

    public static ItemStack getItemStackInSlot(ItemStack itemStack, int slot) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            List<ItemStack> itemStacks = ItemSigilAugmentedHolding.getInternalInventory(itemStack);
            if (itemStacks != null && !itemStacks.isEmpty()) {
                return itemStacks.get(slot == 9 ? 8 : slot);
            }
            return null;
        }
        return null;
    }

    public static int getCurrentItemOrdinal(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            ItemSigilAugmentedHolding.initModeTag(itemStack);
            int currentSigil = itemStack.func_77978_p().func_74762_e("currentSigil");
            currentSigil = MathHelper.func_76125_a((int)currentSigil, (int)0, (int)8);
            return currentSigil;
        }
        return 0;
    }

    public static List<ItemStack> getInternalInventory(ItemStack stack) {
        ArrayList<ItemStack> inv = new ArrayList<ItemStack>(9);
        if (stack != null) {
            ItemSigilAugmentedHolding.initModeTag(stack);
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                return null;
            }
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            if (tagList.func_82582_d()) {
                return null;
            }
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound data = tagList.func_150305_b(i);
                byte j = data.func_74771_c("Slot");
                if (j < 0 || j >= inv.size()) continue;
                inv.set(j, ItemStack.func_77949_a((NBTTagCompound)data));
            }
        }
        return inv;
    }

    public static void cycleToNextSigil(ItemStack itemStack, int mode) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            ItemSigilAugmentedHolding.initModeTag(itemStack);
            int index = mode;
            if (mode == 120 || mode == -120) {
                int currentIndex = ItemSigilAugmentedHolding.getCurrentItemOrdinal(itemStack);
                ItemStack currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, currentIndex);
                if (currentItemStack == null) {
                    return;
                }
                if (mode < 0) {
                    index = BloodArsenalUtils.next(currentIndex, 9);
                    currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack == null) {
                        index = BloodArsenalUtils.next(currentIndex, 9);
                        currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    }
                } else {
                    index = BloodArsenalUtils.prev(currentIndex, 9);
                    currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack == null) {
                        index = BloodArsenalUtils.prev(currentIndex, 9);
                        currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    }
                }
            }
            itemStack.func_77978_p().func_74768_a("currentSigil", index);
        }
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        return Collections.emptyList();
    }
}

