/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.compat.jei.infusion;

import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.recipe.RecipeSanguineInfusion;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class SanguineInfusionWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final ItemStack output;
    private int lpCost;
    private final RecipeSanguineInfusion recipe;
    private final String[] infoString;
    private boolean isModifier = false;
    private int level = 0;

    public SanguineInfusionWrapper(RecipeSanguineInfusion recipe) {
        ArrayList<List<ItemStack>> itemInputs = new ArrayList<List<ItemStack>>();
        if (recipe.getInfuse() != null) {
            itemInputs.add(Collections.singletonList(recipe.getInfuse()));
        }
        ArrayList<ItemStack> extraInputs = new ArrayList<ItemStack>();
        SanguineInfusionWrapper.getItemStacks(recipe, itemInputs, extraInputs);
        this.input = itemInputs;
        this.output = recipe.getOutput();
        this.lpCost = recipe.getLpCost();
        this.recipe = recipe;
        this.isModifier = recipe.isModifier();
        this.infoString = recipe.isModifier() ? new String[]{"jei.bloodarsenal.recipe.requiredLP", TextHelper.localize((String)recipe.getModifier().getUnlocalizedName(), (Object[])new Object[0]), "jei.bloodarsenal.recipe.modifierLevel"} : new String[]{TextHelper.localize((String)"jei.bloodarsenal.recipe.requiredLP", (Object[])new Object[]{this.lpCost})};
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.input);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.isModifier) {
            minecraft.field_71466_p.func_78276_b(TextHelper.localize((String)this.infoString[0], (Object[])new Object[]{(this.level + 1) * this.lpCost}), 110 - minecraft.field_71466_p.func_78256_a(TextHelper.localize((String)this.infoString[0], (Object[])new Object[]{(this.level + 1) * this.lpCost})) / 2, 40, Color.gray.getRGB());
            minecraft.field_71466_p.func_78276_b(this.infoString[1], 10 - minecraft.field_71466_p.func_78256_a(this.infoString[1]) / 2, 4, Color.gray.getRGB());
            minecraft.field_71466_p.func_78276_b(TextHelper.localize((String)this.infoString[2], (Object[])new Object[]{this.level + 1}), 10 - minecraft.field_71466_p.func_78256_a(TextHelper.localize((String)this.infoString[2], (Object[])new Object[]{this.level + 1})) / 2, 14, Color.gray.getRGB());
        } else {
            minecraft.field_71466_p.func_78276_b(this.infoString[0], 110 - minecraft.field_71466_p.func_78256_a(this.infoString[0]) / 2, 40, Color.gray.getRGB());
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public RecipeSanguineInfusion getRecipe() {
        return this.recipe;
    }

    public void setInfoData(int level) {
        this.level = level;
    }

    private static void getItemStacks(RecipeSanguineInfusion recipe, List<List<ItemStack>> itemInputs, List<ItemStack> extraInputs) {
        for (Object o : recipe.getInputs()) {
            if (o instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)o;
                itemInputs.add(Collections.singletonList(new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j())));
                continue;
            }
            if (!(o instanceof String)) continue;
            itemInputs.add(OreDictionary.getOres((String)((String)o)));
        }
    }

    public List<FluidStack> getFluidInputs() {
        return null;
    }

    @Deprecated
    public List<FluidStack> getFluidOutputs() {
        return null;
    }

    @Deprecated
    public List getInputs() {
        return null;
    }

    @Deprecated
    public List getOutputs() {
        return null;
    }

    @Deprecated
    public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }
}

