/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.compat.jei.infusion;

import WayofTime.bloodmagic.api.iface.IActivatable;
import WayofTime.bloodmagic.api.iface.ISigil;
import arc.bloodarsenal.compat.jei.BloodArsenalPlugin;
import arc.bloodarsenal.compat.jei.infusion.SanguineInfusionWrapper;
import arc.bloodarsenal.modifier.IModifiableItem;
import arc.bloodarsenal.modifier.modifiers.ModifierBadPotion;
import arc.bloodarsenal.modifier.modifiers.ModifierBeneficialPotion;
import arc.bloodarsenal.modifier.modifiers.ModifierSigil;
import arc.bloodarsenal.recipe.RecipeSanguineInfusion;
import arc.bloodarsenal.util.BloodArsenalUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SanguineInfusionCategory
implements IRecipeCategory<SanguineInfusionWrapper> {
    public static final String UID = "bloodarsenal:sanguineInfusion";
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;

    public SanguineInfusionCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(103, 103);
        this.localizedName = I18n.func_135052_a((String)"jei.bloodarsenal.recipe.sanguineInfusion", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("bloodarsenal", "textures/gui/sanguine_infusion.png"), 0, 0, 103, 103);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SanguineInfusionWrapper recipeWrapper) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SanguineInfusionWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int centerX = 27;
        int centerY = 57;
        int index = 2;
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        stackGroup.init(0, true, centerX, centerY);
        stackGroup.init(1, false, 77, 8);
        RecipeSanguineInfusion recipe = recipeWrapper.getRecipe();
        List itemInputs = ingredients.getInputs(ItemStack.class);
        if (recipe.isModifier()) {
            ArrayList<ItemStack> potions;
            Object copyStack;
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            if (recipe.getModifier() instanceof ModifierSigil) {
                ArrayList<ItemStack> sigils = new ArrayList<ItemStack>();
                for (ItemStack itemStack : BloodArsenalPlugin.sigils) {
                    if (itemStack == null || !(itemStack.func_77973_b() instanceof ISigil)) continue;
                    copyStack = itemStack.func_77946_l();
                    sigils.add((ItemStack)copyStack);
                }
                itemInputs.add(sigils);
            } else if (recipe.getModifier() instanceof ModifierBadPotion) {
                potions = new ArrayList<ItemStack>();
                for (ItemStack itemStack : BloodArsenalPlugin.badPotions) {
                    if (itemStack == null) continue;
                    copyStack = itemStack.func_77946_l();
                    potions.add((ItemStack)copyStack);
                }
                itemInputs.add(potions);
            } else if (recipe.getModifier() instanceof ModifierBeneficialPotion) {
                potions = new ArrayList();
                for (ItemStack itemStack : BloodArsenalPlugin.beneficialPotions) {
                    if (itemStack == null) continue;
                    copyStack = itemStack.func_77946_l();
                    potions.add((ItemStack)copyStack);
                }
                itemInputs.add(potions);
            }
            for (ItemStack itemStack : BloodArsenalPlugin.modifiables) {
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IModifiableItem) || !(itemStack.func_77973_b() instanceof IActivatable)) continue;
                ItemStack copyStack2 = itemStack.func_77946_l();
                inputs.add(copyStack2);
            }
            stackGroup.set(0, inputs);
            stackGroup.set(1, inputs);
        } else {
            stackGroup.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
            stackGroup.set(1, (ItemStack)ingredients.getOutputs(ItemStack.class).get(0));
            ingredients.getInputs(ItemStack.class).remove(0);
        }
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(ItemStack.class).size();
        Point point = new Point(centerX, centerY - 35);
        Point center = new Point(centerX - 1, centerY);
        for (List inputs : itemInputs) {
            if (recipe.isModifier()) {
                int i;
                for (i = 1; i < recipe.getModifier().getMaxLevel(); ++i) {
                    for (ItemStack itemStack : recipe.getInputsForLevel(i)) {
                        if (!BloodArsenalUtils.areStacksEqual(inputs.get(0), itemStack)) continue;
                        inputs.add(itemStack);
                    }
                }
                for (i = 0; i < inputs.size(); ++i) {
                    if (i >= inputs.size() - 1) continue;
                    if (((ItemStack)inputs.get(i)).func_77942_o()) break;
                    if (((ItemStack)inputs.get((int)i)).field_77994_a != ((ItemStack)inputs.get((int)(i + 1))).field_77994_a) continue;
                    inputs.remove(i);
                    --i;
                }
            }
            stackGroup.init(index, true, point.x, point.y);
            stackGroup.set(index, inputs);
            ++index;
            point = this.rotatePointAbout(point, center, angleBetweenEach);
        }
        if (recipe.isModifier()) {
            int i;
            int modifierLevel = -1;
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
            Map ings = stackGroup.getGuiIngredients();
            for (i = 2; i < ings.size(); ++i) {
                inputStacks.add((ItemStack)((IGuiIngredient)ings.get(i)).getDisplayedIngredient());
            }
            for (i = recipe.getModifier().getMaxLevel() - 1; i >= 0; --i) {
                if (!recipe.matches(inputStacks, i)) continue;
                modifierLevel = i;
                break;
            }
            recipeWrapper.setInfoData(modifierLevel);
        }
    }

    private Point rotatePointAbout(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }

    public void drawAnimations(Minecraft minecraft) {
    }
}

