/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.compat.baubles;

import WayofTime.bloodmagic.api.iface.IMultiWillTool;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.compat.baubles.CustomMeshDefinitionSoulPendant;
import arc.bloodarsenal.compat.baubles.ItemBauble;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSoulPendant
extends ItemBauble
implements IDemonWillGem,
IMeshProvider,
IMultiWillTool {
    public static String[] names = new String[]{"petty", "lesser", "common", "greater", "grand"};

    public ItemSoulPendant(String name) {
        super(name, BaubleType.AMULET);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player;
        ItemStack remainder;
        ItemStack stack = event.getItem().func_92059_d();
        if (stack != null && stack.func_77973_b() instanceof IDemonWill && ((remainder = ItemSoulPendant.addDemonWill(player = event.getEntityPlayer(), stack)) == null || ((IDemonWill)stack.func_77973_b()).getWill(stack) < 1.0E-4 || ItemSoulPendant.isDemonWillFull(EnumDemonWillType.DEFAULT, player))) {
            stack.field_77994_a = 0;
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static boolean isDemonWillFull(EnumDemonWillType type, EntityPlayer player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        ItemStack[] baubleStack = new ItemStack[baubles.func_70302_i_()];
        for (int i = 0; i < baubleStack.length; ++i) {
            baubleStack[i] = baubles.func_70301_a(i);
        }
        inventory.addAll(Arrays.asList(baubleStack));
        inventory.addAll(Arrays.asList(player.field_71071_by.field_70462_a));
        boolean hasGem = false;
        for (ItemStack stack : inventory) {
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            hasGem = true;
            if (!(((IDemonWillGem)stack.func_77973_b()).getWill(type, stack) < (double)((IDemonWillGem)stack.func_77973_b()).getMaxWill(type, stack))) continue;
            return false;
        }
        return hasGem;
    }

    public static ItemStack addDemonWill(EntityPlayer player, ItemStack willStack) {
        if (willStack == null) {
            return null;
        }
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        ItemStack[] baubleStack = new ItemStack[baubles.func_70302_i_()];
        for (int i = 0; i < baubleStack.length; ++i) {
            baubleStack[i] = baubles.func_70301_a(i);
        }
        inventory.addAll(Arrays.asList(baubleStack));
        inventory.addAll(Arrays.asList(player.field_71071_by.field_70462_a));
        for (ItemStack stack : inventory) {
            ItemStack newStack;
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem) || (newStack = ((IDemonWillGem)stack.func_77973_b()).fillDemonWillGem(stack, willStack)) != null) continue;
            return null;
        }
        return willStack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + names[stack.func_77952_i()];
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return super.func_77659_a(itemStack, world, player, hand);
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        double drain = Math.min(this.getWill(type, stack), (double)(this.getMaxWill(type, stack) / 10));
        double filled = PlayerDemonWillHandler.addDemonWill((EnumDemonWillType)type, (EntityPlayer)player, (double)drain, (ItemStack)stack);
        this.drainWill(type, stack, filled, true);
        return super.func_77659_a(itemStack, world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionSoulPendant("ItemSoulPendant");
    }

    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            ret.add("type=petty_" + type.func_176610_l().toLowerCase());
            ret.add("type=lesser_" + type.func_176610_l().toLowerCase());
            ret.add("type=common_" + type.func_176610_l().toLowerCase());
            ret.add("type=greater_" + type.func_176610_l().toLowerCase());
            ret.add("type=grand_" + type.func_176610_l().toLowerCase());
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < names.length; ++i) {
            ItemStack emptyStack = new ItemStack((Item)this, 1, i);
            list.add(emptyStack);
        }
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            for (int i = 0; i < names.length; ++i) {
                ItemStack fullStack = new ItemStack((Item)this, 1, i);
                this.setWill(type, fullStack, this.getMaxWill(EnumDemonWillType.DEFAULT, fullStack));
                list.add(fullStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        tooltip.add(TextHelper.localize((String)("tooltip.bloodarsenal.soulPendant." + names[stack.func_77952_i()]), (Object[])new Object[0]));
        tooltip.add(TextHelper.localize((String)"tooltip.BloodMagic.will", (Object[])new Object[]{this.getWill(type, stack)}));
        tooltip.add(TextHelper.localizeEffect((String)("tooltip.BloodMagic.currentType." + this.getCurrentType(stack).func_176610_l().toLowerCase()), (Object[])new Object[0]));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1.0;
        }
        return 1.0 - this.getWill(type, stack) / maxWill;
    }

    public ItemStack fillDemonWillGem(ItemStack soulGemStack, ItemStack soulStack) {
        if (soulStack != null && soulStack.func_77973_b() instanceof IDemonWill) {
            EnumDemonWillType thisType = this.getCurrentType(soulGemStack);
            if (thisType != EnumDemonWillType.DEFAULT) {
                return soulStack;
            }
            IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
            double soulsLeft = this.getWill(thisType, soulGemStack);
            if (soulsLeft < (double)this.getMaxWill(thisType, soulGemStack)) {
                double newSoulsLeft = Math.min(soulsLeft + soul.getWill(soulStack), (double)this.getMaxWill(thisType, soulGemStack));
                soul.drainWill(soulStack, newSoulsLeft - soulsLeft);
                this.setWill(thisType, soulGemStack, newSoulsLeft);
                if (soul.getWill(soulStack) <= 0.0) {
                    return null;
                }
            }
        }
        return soulStack;
    }

    public double getWill(EnumDemonWillType type, ItemStack soulGemStack) {
        if (!type.equals((Object)this.getCurrentType(soulGemStack))) {
            return 0.0;
        }
        NBTTagCompound tag = soulGemStack.func_77978_p();
        return tag.func_74769_h("souls");
    }

    public void setWill(EnumDemonWillType type, ItemStack soulGemStack, double souls) {
        this.setCurrentType(type, soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        tag.func_74780_a("souls", souls);
    }

    public double drainWill(EnumDemonWillType type, ItemStack soulGemStack, double drainAmount, boolean doDrain) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (currentType != type) {
            return 0.0;
        }
        double souls = this.getWill(type, soulGemStack);
        double soulsDrained = Math.min(drainAmount, souls);
        this.setWill(type, soulGemStack, souls - soulsDrained);
        return soulsDrained;
    }

    public int getMaxWill(EnumDemonWillType type, ItemStack soulGemStack) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (!type.equals((Object)currentType) && currentType != EnumDemonWillType.DEFAULT) {
            return 0;
        }
        switch (soulGemStack.func_77960_j()) {
            case 0: {
                return 64;
            }
            case 1: {
                return 256;
            }
            case 2: {
                return 1024;
            }
            case 3: {
                return 4096;
            }
            case 4: {
                return 16384;
            }
        }
        return 64;
    }

    public EnumDemonWillType getCurrentType(ItemStack soulGemStack) {
        NBTHelper.checkNBT((ItemStack)soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf((String)tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public void setCurrentType(EnumDemonWillType type, ItemStack soulGemStack) {
        NBTHelper.checkNBT((ItemStack)soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        if (type == EnumDemonWillType.DEFAULT) {
            if (tag.func_74764_b("demonWillType")) {
                tag.func_82580_o("demonWillType");
            }
            return;
        }
        tag.func_74778_a("demonWillType", type.toString());
    }

    public double fillWill(EnumDemonWillType type, ItemStack stack, double fillAmount, boolean doFill) {
        if (!type.equals((Object)this.getCurrentType(stack)) && this.getWill(this.getCurrentType(stack), stack) > 0.0) {
            return 0.0;
        }
        double current = this.getWill(type, stack);
        double maxWill = this.getMaxWill(type, stack);
        double filled = Math.min(fillAmount, maxWill - current);
        if (filled > 0.0) {
            this.setWill(type, stack, filled + current);
            return filled;
        }
        return 0.0;
    }
}

