/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal.compat.baubles;

import WayofTime.bloodmagic.api.altar.IAltarManipulator;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IItemLPContainer;
import WayofTime.bloodmagic.api.util.helper.ItemHelper;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.compat.baubles.BaubleUtils;
import arc.bloodarsenal.compat.baubles.CompatBaubles;
import arc.bloodarsenal.compat.baubles.ItemBauble;
import baubles.api.BaubleType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSacrificeAmulet
extends ItemBauble
implements IAltarManipulator,
IItemLPContainer,
IVariantProvider {
    public final int CAPACITY = 10000;

    public ItemSacrificeAmulet(String name) {
        super(name, BaubleType.AMULET);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack baubleStack;
        if (CompatBaubles.SACRIFICE_AMULET == null || event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !PlayerHelper.isFakePlayer((EntityPlayer)((EntityPlayer)event.getSource().func_76346_g())) && (baubleStack = BaubleUtils.getBaubleStackInPlayer(player = (EntityPlayer)event.getSource().func_76346_g(), this)) != null && baubleStack.func_77973_b() instanceof ItemSacrificeAmulet) {
            ItemSacrificeAmulet amulet = (ItemSacrificeAmulet)baubleStack.func_77973_b();
            boolean shouldSyphon = amulet.getStoredLP(baubleStack) < amulet.CAPACITY;
            float damageDone = event.getEntityLiving().func_110143_aJ() < event.getAmount() ? event.getAmount() - event.getEntityLiving().func_110143_aJ() : event.getAmount();
            int totalLP = Math.round(damageDone * (float)ConfigHandler.sacrificeAmuletConversion);
            if (shouldSyphon) {
                ItemHelper.LPContainer.addLPToItem((ItemStack)baubleStack, (int)totalLP, (int)amulet.CAPACITY);
            }
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return super.func_77659_a(itemStack, world, player, hand);
        }
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null) {
            return super.func_77659_a(itemStack, world, player, EnumHand.MAIN_HAND);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(rayTrace.func_178782_a());
            if (!(tile instanceof IBloodAltar)) {
                return super.func_77659_a(itemStack, world, player, EnumHand.MAIN_HAND);
            }
            ItemHelper.LPContainer.tryAndFillAltar((IBloodAltar)((IBloodAltar)tile), (ItemStack)stack, (World)world, (BlockPos)rayTrace.func_178782_a());
        }
        return super.func_77659_a(itemStack, world, player, hand);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        list.add(TextHelper.localize((String)"tooltip.bloodarsenal.selfSacrificeAmulet.desc", (Object[])new Object[0]));
        list.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.stored", (Object[])new Object[]{this.getStoredLP(stack)}));
        super.func_77624_a(stack, player, list, advanced);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (this.getStoredLP(itemstack) > 10000) {
            this.setStoredLP(itemstack, 10000);
        }
    }

    public int getCapacity() {
        return this.CAPACITY;
    }

    public int getStoredLP(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74762_e("storedLP") : 0;
    }

    public void setStoredLP(ItemStack stack, int lp) {
        if (stack != null) {
            NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74768_a("storedLP", lp);
        }
    }

    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=normal"));
        return ret;
    }
}

