/*
 * Decompiled with CFR 0.152.
 */
package arc.bloodarsenal;

import WayofTime.bloodmagic.api.util.helper.LogHelper;
import arc.bloodarsenal.ConfigHandler;
import arc.bloodarsenal.client.gui.GuiHandler;
import arc.bloodarsenal.command.CommandBloodArsenal;
import arc.bloodarsenal.compat.ICompatibility;
import arc.bloodarsenal.network.BloodArsenalPacketHandler;
import arc.bloodarsenal.proxy.CommonProxy;
import arc.bloodarsenal.registry.ModBlocks;
import arc.bloodarsenal.registry.ModCompat;
import arc.bloodarsenal.registry.ModEntities;
import arc.bloodarsenal.registry.ModItems;
import arc.bloodarsenal.registry.ModModifiers;
import arc.bloodarsenal.registry.ModPotions;
import arc.bloodarsenal.registry.ModRecipes;
import arc.bloodarsenal.registry.ModRituals;
import arc.bloodarsenal.util.DamageSourceBleeding;
import arc.bloodarsenal.util.DamageSourceGlass;
import java.io.File;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="bloodarsenal", version="1.10.2-2.1.0-22", name="Blood Arsenal", dependencies="required-after:BloodMagic;after:Baubles;after:Guidepi", guiFactory="arc.bloodarsenal.client.gui.config.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BloodArsenal {
    public static final String MOD_ID = "bloodarsenal";
    public static final String VERSION = "1.10.2-2.1.0-22";
    public static final String DOMAIN = "bloodarsenal".toLowerCase(Locale.ENGLISH) + ":";
    @SidedProxy(serverSide="arc.bloodarsenal.proxy.CommonProxy", clientSide="arc.bloodarsenal.proxy.ClientProxy")
    public static CommonProxy PROXY;
    @Mod.Instance(value="bloodarsenal")
    public static BloodArsenal INSTANCE;
    public static final CreativeTabs TAB_BLOOD_ARSENAL;
    private LogHelper logger = new LogHelper("bloodarsenal");
    private File configDir;
    private static boolean isDev;

    public LogHelper getLogger() {
        return this.logger;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public boolean isDev() {
        return isDev;
    }

    public static DamageSourceGlass getDamageSourceGlass() {
        return new DamageSourceGlass();
    }

    public static DamageSourceBleeding getDamageSourceBleeding() {
        return new DamageSourceBleeding();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getModConfigurationDirectory(), "BloodArsenal");
        ConfigHandler.init(new File(this.getConfigDir(), "BloodArsenal.cfg"));
        ModBlocks.initTiles();
        ModBlocks.addOreDictBlocks();
        ModItems.addOreDictItems();
        ModPotions.init();
        ModEntities.init();
        ModCompat.registerModCompat();
        ModCompat.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        PROXY.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BloodArsenalPacketHandler.init();
        ModRecipes.init();
        ModRituals.overrideRituals();
        ModModifiers.init();
        ModCompat.loadCompat(ICompatibility.InitializationPhase.INIT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        PROXY.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModCompat.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        PROXY.postInit();
    }

    @Mod.EventHandler
    public void modMapping(FMLModIdMappingEvent event) {
        ModCompat.loadCompat(ICompatibility.InitializationPhase.MAPPING);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBloodArsenal());
    }

    static {
        TAB_BLOOD_ARSENAL = new CreativeTabs("bloodarsenal.creativeTab"){

            public Item func_78016_d() {
                return ModItems.BLOOD_ORANGE;
            }
        };
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

