/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity.multiblock;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactory;
import ipsis.woot.block.BlockMobFactoryStructure;
import ipsis.woot.tileentity.LayoutBlockInfo;
import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.TileEntityMobFactoryController;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryModule;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.tileentity.multiblock.MobFactoryModule;
import ipsis.woot.util.BlockPosHelper;
import ipsis.woot.util.StringHelper;
import ipsis.woot.util.UnlocalizedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class MobFactoryMultiblockLogic {
    public static FactorySetup validateFactory(TileEntityMobFactory factory, boolean feedback, EntityPlayer player) {
        FactorySetup factorySetup = MobFactoryMultiblockLogic.validateFactory(factory, EnumMobFactoryTier.TIER_FOUR, feedback, player);
        if (factorySetup.size != null) {
            return factorySetup;
        }
        factorySetup = MobFactoryMultiblockLogic.validateFactory(factory, EnumMobFactoryTier.TIER_THREE, feedback, player);
        if (factorySetup.size != null) {
            return factorySetup;
        }
        factorySetup = MobFactoryMultiblockLogic.validateFactory(factory, EnumMobFactoryTier.TIER_TWO, feedback, player);
        if (factorySetup.size != null) {
            return factorySetup;
        }
        return MobFactoryMultiblockLogic.validateFactory(factory, EnumMobFactoryTier.TIER_ONE, feedback, player);
    }

    public static FactorySetup validateFactory(TileEntityMobFactory factory) {
        return MobFactoryMultiblockLogic.validateFactory(factory, false, null);
    }

    public static void getFactoryLayout(EnumMobFactoryTier tier, BlockPos origin, EnumFacing facing, List<LayoutBlockInfo> layoutBlockInfoList) {
        for (MobFactoryModule s : tier.structureModules) {
            BlockPos p = BlockPosHelper.rotateFromSouth(s.getOffset(), facing.func_176734_d());
            p = origin.func_177971_a((Vec3i)p);
            layoutBlockInfoList.add(new LayoutBlockInfo(p, s.moduleType));
        }
    }

    static void validateChat(EntityPlayer player, String s) {
        if (player != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(s));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FactorySetup validateFactory(TileEntityMobFactory factory, EnumMobFactoryTier tier, boolean feedback, EntityPlayer player) {
        FactorySetup factorySetup = new FactorySetup();
        BlockPos controllerPos = factory.func_174877_v().func_177981_b(1);
        TileEntity te = factory.func_145831_w().func_175625_s(controllerPos);
        if (!(te instanceof TileEntityMobFactoryController)) {
            if (!feedback) return factorySetup;
            MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("validate.Woot:factory.missing_controller"), new Object[]{tier}));
            return factorySetup;
        }
        TileEntityMobFactoryController teController = (TileEntityMobFactoryController)te;
        if (teController.getMobName().equals("")) {
            if (!feedback || player == null) return factorySetup;
            MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("validate.Woot:factory.missing_mob"), new Object[]{tier}));
            return factorySetup;
        }
        if (!Woot.mobRegistry.isPrismValid(teController.getMobName())) {
            if (!feedback) return new FactorySetup();
            MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("chat.Woot:mob.invalid"), teController.getModDisplayName(), teController.getMobName()));
            return new FactorySetup();
        }
        factorySetup.mobName = teController.getMobName();
        factorySetup.displayName = teController.getModDisplayName();
        BlockPos patternOrigin = factory.func_174877_v();
        if (!feedback) {
            if (!MobFactoryMultiblockLogic.isSize(factory, tier)) return factorySetup;
            factorySetup.size = tier;
        } else {
            factorySetup.size = tier;
        }
        EnumFacing f = (EnumFacing)factory.func_145831_w().func_180495_p(factory.func_174877_v()).func_177229_b((IProperty)BlockMobFactory.FACING);
        for (MobFactoryModule s : factorySetup.size.structureModules) {
            BlockPos p = BlockPosHelper.rotateFromSouth(s.getOffset(), f.func_176734_d());
            p = patternOrigin.func_177971_a((Vec3i)p);
            if (!factory.func_145831_w().func_175667_e(p)) {
                return new FactorySetup();
            }
            IBlockState iBlockState = factory.func_145831_w().func_180495_p(p);
            Block block = iBlockState.func_177230_c();
            if (!(block instanceof BlockMobFactoryStructure)) {
                if (!feedback) return new FactorySetup();
                String name = UnlocalizedName.getUnlocalizedNameBlock("structure") + "." + (Object)((Object)s.moduleType) + ".name";
                MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("validate.Woot:factory.invalid_block"), new Object[]{tier, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), StringHelper.localize(name)}));
                return new FactorySetup();
            }
            if (((BlockMobFactoryStructure)block).getModuleTypeFromState(iBlockState) != s.moduleType) {
                if (!feedback) return new FactorySetup();
                String name = UnlocalizedName.getUnlocalizedNameBlock("structure") + "." + (Object)((Object)s.moduleType) + ".name";
                MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("validate.Woot:factory.invalid_block"), new Object[]{tier, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), StringHelper.localize(name)}));
                return new FactorySetup();
            }
            factorySetup.blockPosList.add(p);
        }
        MobFactoryMultiblockLogic.validateChat(player, TextFormatting.GREEN + String.format(StringHelper.localize("validate.Woot:factory.blocks_ok"), new Object[]{tier}));
        boolean validMobLevel = Woot.tierMapper.isTierValid(teController.getMobName(), teController.getXpValue(), factorySetup.size);
        if (validMobLevel) return factorySetup;
        if (!feedback) return new FactorySetup();
        MobFactoryMultiblockLogic.validateChat(player, TextFormatting.RED + String.format(StringHelper.localize("validate.Woot:factory.mob_tier"), new Object[]{tier}));
        return new FactorySetup();
    }

    static boolean isSize(TileEntityMobFactory factory, EnumMobFactoryTier size) {
        EnumMobFactoryModule module;
        BlockPos pos;
        if (size == EnumMobFactoryTier.TIER_ONE) {
            pos = new BlockPos(2, -1, -2);
            module = EnumMobFactoryModule.BLOCK_1;
        } else if (size == EnumMobFactoryTier.TIER_TWO) {
            pos = new BlockPos(3, -1, -3);
            module = EnumMobFactoryModule.BLOCK_3;
        } else if (size == EnumMobFactoryTier.TIER_THREE) {
            pos = new BlockPos(4, -1, -4);
            module = EnumMobFactoryModule.BLOCK_4;
        } else {
            pos = new BlockPos(5, -1, -5);
            module = EnumMobFactoryModule.BLOCK_5;
        }
        EnumFacing f = (EnumFacing)factory.func_145831_w().func_180495_p(factory.func_174877_v()).func_177229_b((IProperty)BlockMobFactory.FACING);
        pos = BlockPosHelper.rotateFromSouth(pos, f.func_176734_d());
        pos = factory.func_174877_v().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        IBlockState iBlockState = factory.func_145831_w().func_180495_p(pos);
        Block b = iBlockState.func_177230_c();
        if (b instanceof BlockMobFactoryStructure) {
            return ((BlockMobFactoryStructure)b).getModuleTypeFromState(iBlockState) == module;
        }
        return false;
    }

    static {
        EnumMobFactoryTier.TIER_ONE.buildStructureMap();
        EnumMobFactoryTier.TIER_TWO.buildStructureMap();
        EnumMobFactoryTier.TIER_THREE.buildStructureMap();
        EnumMobFactoryTier.TIER_FOUR.buildStructureMap();
    }

    public static class FactorySetup {
        List<BlockPos> blockPosList = new ArrayList<BlockPos>();
        EnumMobFactoryTier size = null;
        String mobName = "";
        String displayName = "";

        public EnumMobFactoryTier getSize() {
            return this.size;
        }

        public List<BlockPos> getBlockPosList() {
            return this.blockPosList;
        }

        public boolean isValid() {
            return this.size != null;
        }

        public String getMobName() {
            return this.mobName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

