/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.tileentity.TileEntityMobFactory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityMobFactoryController
extends TileEntity {
    String mobName = "";
    String displayName = "";
    int xpValue = 1;
    static final String NBT_MOB_NAME = "mobName";
    public static final String NBT_DISPLAY_NAME = "displayName";
    static final String NBT_XP_VALUE = "mobXpCost";

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeControllerToNBT(compound);
        return compound;
    }

    public void writeControllerToNBT(NBTTagCompound compound) {
        compound.func_74778_a(NBT_MOB_NAME, this.mobName);
        compound.func_74778_a(NBT_DISPLAY_NAME, this.displayName);
        compound.func_74768_a(NBT_XP_VALUE, this.xpValue);
    }

    public void readControllerFromNBT(NBTTagCompound compound) {
        this.mobName = compound.func_74779_i(NBT_MOB_NAME);
        this.displayName = compound.func_74779_i(NBT_DISPLAY_NAME);
        this.xpValue = compound.func_74762_e(NBT_XP_VALUE);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readControllerFromNBT(compound);
    }

    public void setMobName(String mobName, String displayName, int xp) {
        this.mobName = mobName;
        this.displayName = displayName;
        this.xpValue = xp;
        this.func_70296_d();
        this.updateMobFarm();
    }

    public String getMobName() {
        return this.mobName;
    }

    public String getModDisplayName() {
        return this.displayName;
    }

    public int getXpValue() {
        return this.xpValue;
    }

    void updateMobFarm() {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN));
        if (te instanceof TileEntityMobFactory) {
            ((TileEntityMobFactory)te).interruptStructure();
        }
    }

    public void blockAdded() {
        this.updateMobFarm();
    }

    public void func_145843_s() {
        this.updateMobFarm();
    }

    public ItemStack getDroppedItemStack() {
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)ModBlocks.blockController), 1);
        if (Woot.mobRegistry.isValidMobName(this.mobName)) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeControllerToNBT(tag);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }
}

