/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactory;
import ipsis.woot.init.ModItems;
import ipsis.woot.manager.ControllerConfig;
import ipsis.woot.manager.EnergyManager;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.ProxyManager;
import ipsis.woot.manager.SpawnerManager;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.manager.UpgradeSetup;
import ipsis.woot.plugins.bloodmagic.BloodMagic;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.TileEntityMobFactoryStructure;
import ipsis.woot.tileentity.TileEntityMobFactoryUpgrade;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.tileentity.multiblock.MobFactoryMultiblockLogic;
import ipsis.woot.util.BlockPosHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityMobFactory
extends TileEntity
implements ITickable {
    EnumMobFactoryTier factoryTier = null;
    SpawnerManager.SpawnReq spawnReq = null;
    boolean nbtLoaded = false;
    UpgradeSetup upgradeSetup;
    ControllerConfig controllerConfig;
    AxisAlignedBB bb;
    ProxyManager proxyManager;
    public static final int LOOTBOX_Y = 253;
    int currLearnTicks = 0;
    int currSpawnTicks = 0;
    int consumedRf = 0;
    int storedXp = 0;
    int learnTicksOffset;
    boolean running = true;
    int structureTicks = 0;
    boolean dirtyStructure = true;
    boolean dirtyUpgrade = false;
    boolean dirtyProxy;
    boolean hasLootBox = true;
    List<BlockPos> structureBlockList = new ArrayList<BlockPos>();
    List<BlockPos> upgradeBlockList = new ArrayList<BlockPos>();
    static final String NBT_CURR_SPAWN_TICK = "spawnTicks";
    static final String NBT_CONSUMED_RF = "consumedRf";
    static final String NBT_STORED_XP = "storedXp";
    static final String NBT_RUNNING = "running";
    static final int MULTIBLOCK_BACKOFF_SCAN_TICKS = 20;
    private long lastWorldTime = 0L;
    private boolean bmKeepAlive = false;
    private int bmMobCount = 0;
    private int bmSacrificeAmount = 0;
    protected EnergyManager energyManager = new EnergyManager(Settings.maxPower, Integer.MAX_VALUE, this);

    void setCurrSpawnTicks(int ticks) {
        if (this.currSpawnTicks != ticks) {
            this.currSpawnTicks = ticks;
            this.func_70296_d();
        }
    }

    void incCurrSpawnTicks() {
        ++this.currSpawnTicks;
        this.func_70296_d();
    }

    void setConsumedRf(int rf) {
        if (this.consumedRf != rf) {
            this.consumedRf = rf;
            this.func_70296_d();
        }
    }

    void setStoredXp(int xp) {
        if (this.storedXp != xp) {
            this.storedXp = xp;
            this.func_70296_d();
        }
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.isFormed()) {
            return compound;
        }
        compound.func_74768_a(NBT_CURR_SPAWN_TICK, this.currSpawnTicks);
        compound.func_74768_a(NBT_CONSUMED_RF, this.consumedRf);
        compound.func_74768_a(NBT_STORED_XP, this.storedXp);
        compound.func_74757_a(NBT_RUNNING, this.running);
        this.energyManager.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_CURR_SPAWN_TICK)) {
            this.currSpawnTicks = compound.func_74762_e(NBT_CURR_SPAWN_TICK);
            this.consumedRf = compound.func_74762_e(NBT_CONSUMED_RF);
            this.storedXp = compound.func_74762_e(NBT_STORED_XP);
            this.running = compound.func_74764_b(NBT_RUNNING) ? compound.func_74767_n(NBT_RUNNING) : true;
            this.nbtLoaded = true;
        }
        this.energyManager.readFromNBT(compound);
    }

    public TileEntityMobFactory() {
        this.upgradeSetup = new UpgradeSetup();
        this.controllerConfig = new ControllerConfig();
        this.proxyManager = new ProxyManager(this);
        this.learnTicksOffset = Settings.learnTicks + Woot.RANDOM.nextInt(11);
    }

    public String getMobName() {
        return this.controllerConfig.getMobName();
    }

    public String getMobDisplayName() {
        return this.controllerConfig.getDisplayName();
    }

    public SpawnerManager.SpawnReq getSpawnReq() {
        return this.spawnReq;
    }

    public EnumMobFactoryTier getFactoryTier() {
        return this.factoryTier;
    }

    public UpgradeSetup getUpgradeSetup() {
        return this.upgradeSetup;
    }

    public int getConsumedRf() {
        return this.consumedRf;
    }

    void setRunning(boolean running) {
        if (this.running != running) {
            this.running = running;
            this.func_70296_d();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isFormed() {
        return this.factoryTier != null && Woot.mobRegistry.isValidMobName(this.controllerConfig.getMobName()) && this.spawnReq != null && Woot.mobRegistry.isPrismValid(this.controllerConfig.getMobName());
    }

    void updateStructureBlocks(boolean connected) {
        for (BlockPos p : this.structureBlockList) {
            TileEntity te;
            if (!this.field_145850_b.func_175667_e(p) || !((te = this.field_145850_b.func_175625_s(p)) instanceof TileEntityMobFactoryStructure)) continue;
            if (connected) {
                ((TileEntityMobFactoryStructure)te).setMaster(this);
                continue;
            }
            ((TileEntityMobFactoryStructure)te).clearMaster();
        }
    }

    void updateUpgradeBlocks(boolean connected) {
        for (BlockPos p : this.upgradeBlockList) {
            TileEntity te;
            if (!this.field_145850_b.func_175667_e(p) || !((te = this.field_145850_b.func_175625_s(p)) instanceof TileEntityMobFactoryUpgrade)) continue;
            if (connected) {
                ((TileEntityMobFactoryUpgrade)te).setMaster(this);
                continue;
            }
            ((TileEntityMobFactoryUpgrade)te).clearMaster();
        }
    }

    void onStructureCheck() {
        EnumMobFactoryTier oldFactoryTier = this.factoryTier;
        MobFactoryMultiblockLogic.FactorySetup factorySetup = MobFactoryMultiblockLogic.validateFactory(this);
        if (factorySetup.getSize() == null) {
            this.updateStructureBlocks(false);
            this.updateUpgradeBlocks(false);
            this.proxyManager.setMaster(false);
            this.factoryTier = factorySetup.getSize();
            this.controllerConfig.clearMobName();
            return;
        }
        if (oldFactoryTier != this.factoryTier) {
            this.updateStructureBlocks(false);
        }
        this.factoryTier = factorySetup.getSize();
        this.controllerConfig.setMobName(factorySetup.getMobName(), factorySetup.getDisplayName());
        this.structureBlockList = factorySetup.getBlockPosList();
        this.updateStructureBlocks(true);
        this.onUpgradeCheck();
        this.onProxyCheck();
    }

    void onUpgradeCheck() {
        this.updateUpgradeBlocks(false);
        this.upgradeSetup.clear();
        this.upgradeBlockList.clear();
        if (this.factoryTier == EnumMobFactoryTier.TIER_ONE) {
            this.upgradeTier1();
        } else if (this.factoryTier == EnumMobFactoryTier.TIER_TWO) {
            this.upgradeTier2();
        } else if (this.factoryTier == EnumMobFactoryTier.TIER_THREE || this.factoryTier == EnumMobFactoryTier.TIER_FOUR) {
            this.upgradeTier3();
        }
        this.spawnReq = Woot.spawnerManager.getSpawnReq(this.controllerConfig.getMobName(), this.upgradeSetup, this, this.factoryTier);
        if (this.nbtLoaded) {
            this.nbtLoaded = false;
        } else {
            this.setConsumedRf(0);
            this.setCurrSpawnTicks(0);
        }
        this.updateUpgradeBlocks(true);
    }

    void onProxyCheck() {
        this.proxyManager.setMaster(false);
        this.proxyManager.scanProxy();
    }

    public void manualValidate(EntityPlayer player) {
        MobFactoryMultiblockLogic.FactorySetup factorySetup = MobFactoryMultiblockLogic.validateFactory(this, true, player);
    }

    void upgradeTierX(BlockPos[] upgradePos, int maxTier) {
        ArrayList<SpawnerUpgrade> tmpUpgradeList = new ArrayList<SpawnerUpgrade>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        for (BlockPos p : upgradePos) {
            BlockPos offset = BlockPosHelper.rotateFromSouth(p, f.func_176734_d());
            BlockPos p2 = this.func_174877_v().func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
            UpgradeManager.scanUpgradeTotem(this.field_145850_b, p2, maxTier, tmpUpgradeList, this.upgradeBlockList);
        }
        this.upgradeSetup.processUpgrades(tmpUpgradeList);
    }

    void upgradeTier1() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0)};
        this.upgradeTierX(upgradePos, 1);
    }

    void upgradeTier2() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0)};
        this.upgradeTierX(upgradePos, 2);
    }

    void upgradeTier3() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0)};
        this.upgradeTierX(upgradePos, 3);
    }

    private boolean isMachinePowered() {
        boolean controller = this.field_145850_b.func_175640_z(this.field_174879_c);
        boolean proxy = this.proxyManager.isBlockPowered();
        return controller || proxy;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long currWorldTime = this.field_145850_b.func_82737_E();
        if (currWorldTime == this.lastWorldTime) {
            return;
        }
        this.lastWorldTime = currWorldTime;
        ++this.structureTicks;
        if (this.dirtyStructure && this.structureTicks >= 20) {
            this.onStructureCheck();
            this.dirtyStructure = false;
            this.dirtyUpgrade = false;
        }
        if (this.dirtyUpgrade && this.structureTicks >= 20) {
            this.onUpgradeCheck();
            this.dirtyUpgrade = false;
        }
        if (this.dirtyProxy) {
            this.onProxyCheck();
            this.dirtyProxy = false;
        }
        if (this.structureTicks >= 20) {
            this.structureTicks = 0;
        }
        boolean powered = this.isMachinePowered();
        if (this.running && powered) {
            this.setRunning(false);
        } else if (!this.running && !powered) {
            this.setRunning(true);
        }
        if (!this.isFormed()) {
            return;
        }
        this.tryPickupModItems();
        ++this.currLearnTicks;
        if (this.currLearnTicks >= this.learnTicksOffset) {
            if (!Woot.LOOT_TABLE_MANAGER.isFull(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey())) {
                BlockPos spawnPos = new BlockPos((Vec3i)this.func_174877_v());
                Woot.spawnerManager.spawn(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey(), this.field_145850_b, this.func_174877_v());
                this.hasLootBox = true;
            } else if (this.hasLootBox) {
                BlockPos spawnPos = new BlockPos((Vec3i)this.func_174877_v());
                Woot.spawnerManager.destroyLootBox(this.func_145831_w(), spawnPos);
                this.hasLootBox = false;
            }
            this.currLearnTicks = 0;
        }
        if (Woot.LOOT_TABLE_MANAGER.isEmpty(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey())) {
            return;
        }
        if (this.running) {
            this.incCurrSpawnTicks();
            this.processPower();
            if (this.currSpawnTicks >= this.spawnReq.getSpawnTime()) {
                this.onSpawn();
                this.setCurrSpawnTicks(0);
            }
        }
    }

    private void tryPickupModItems() {
        EnumEnchantKey key = this.upgradeSetup.getEnchantKey();
        String mobName = this.controllerConfig.getMobName();
        if (!Woot.LOOT_TABLE_MANAGER.isFull(mobName, key)) {
            List itemList;
            if (this.bb == null) {
                BlockPos checkPos = new BlockPos(this.func_174877_v().func_177958_n(), 253, this.func_174877_v().func_177952_p());
                int range = 2;
                this.bb = new AxisAlignedBB(checkPos).func_72314_b((double)range, 0.0, (double)range);
            }
            if (!(itemList = this.field_145850_b.func_175647_a(EntityItem.class, this.bb, EntitySelectors.field_94557_a)).isEmpty()) {
                Woot.LOOT_TABLE_MANAGER.update(mobName, key, itemList, false);
                for (EntityItem i : itemList) {
                    i.func_70106_y();
                }
            }
        }
    }

    public void interruptStructure() {
        this.dirtyStructure = true;
    }

    public void interruptUpgrade() {
        this.dirtyUpgrade = true;
    }

    public void interruptProxy() {
        this.dirtyProxy = true;
    }

    void processPower() {
        int drawnRf = this.energyManager.extractEnergyInternal(this.spawnReq.getRfPerTick());
        if (Woot.devMode) {
            drawnRf = this.spawnReq.getRfPerTick();
        }
        if (drawnRf == this.spawnReq.getRfPerTick()) {
            this.setConsumedRf(this.consumedRf + drawnRf);
        } else if (Settings.strictPower) {
            this.setConsumedRf(0);
        } else {
            this.setConsumedRf(this.consumedRf + drawnRf);
        }
    }

    private boolean bmUseTanks(int mobCount) {
        TileEntity te;
        if (!this.bmKeepAlive || BloodMagic.fluidOutput == null) {
            return false;
        }
        ArrayList<Object> validHandlers = new ArrayList<Object>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        if (this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(f)) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) {
            validHandlers.add(te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()));
        }
        validHandlers.addAll(this.proxyManager.getIFluidHandlers());
        if (validHandlers.isEmpty()) {
            return false;
        }
        int upgradeSacrificeCount = UpgradeManager.getSpawnerUpgrade(this.upgradeSetup.getBmUpgrade()).getSacrificeCount();
        float sacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgradeSacrificeCount);
        int amount = (int)((1.0f + sacrificeEfficiencyMultiplier) * 20.0f) * mobCount;
        FluidStack out = new FluidStack(BloodMagic.fluidOutput, amount);
        for (IFluidHandler iFluidHandler : validHandlers) {
            if (out.amount == 0) break;
            int result = iFluidHandler.fill(out, true);
            out.amount -= result;
            if (out.amount >= 0) continue;
            out.amount = 0;
        }
        this.bmMobCount = 0;
        this.bmSacrificeAmount = 0;
        return true;
    }

    private void bmUseRitual(int mobCount, int sacrificeAmount) {
        this.bmKeepAlive = false;
        this.bmMobCount = mobCount;
        this.bmSacrificeAmount = sacrificeAmount;
    }

    private void bmOutput(UpgradeSetup upgradeSetup) {
        if (!upgradeSetup.hasBmUpgrade()) {
            this.bmClear();
            return;
        }
        int mobCount = Settings.baseMobCount;
        if (upgradeSetup.hasMassUpgrade()) {
            mobCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
        }
        int sacrificeAmount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getBmUpgrade()).getAltarLifeEssence();
        if (!this.bmUseTanks(mobCount)) {
            this.bmUseRitual(mobCount, sacrificeAmount);
        }
        this.bmKeepAlive = false;
    }

    private boolean canRemoveItemStack(IItemHandler itemHandler, ItemStack itemStack, int amount) {
        if (amount <= 0) {
            return true;
        }
        if (itemHandler.getSlots() == 0) {
            return false;
        }
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack s = itemHandler.getStackInSlot(i);
            if (s == null) continue;
            if (s.func_77969_a(itemStack)) {
                found += s.field_77994_a;
            }
            if (found >= amount) break;
        }
        return found >= amount;
    }

    private void removeItemStack(IItemHandler itemHandler, ItemStack itemStack, int amount) {
        int left = amount;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack removeStack = itemHandler.getStackInSlot(i);
            if (removeStack == null) continue;
            if (removeStack.func_77969_a(itemStack)) {
                ItemStack t = itemHandler.extractItem(i, left, false);
                left -= t.field_77994_a;
            }
            if (left == 0) break;
        }
    }

    private boolean processExtraSpawnReq(String wootName, UpgradeSetup upgradeSetup) {
        if (!Woot.SPAWN_REQ_MANAGER.hasExtraSpawnReq(wootName)) {
            return true;
        }
        List<ItemStack> requiredItems = Woot.SPAWN_REQ_MANAGER.getItems(wootName, upgradeSetup);
        FluidStack fluidStack = Woot.SPAWN_REQ_MANAGER.getFluid(wootName, upgradeSetup);
        if (!requiredItems.isEmpty()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(EnumFacing.UP, 2));
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                boolean allItemsPresent = true;
                for (ItemStack itemStack : requiredItems) {
                    if (this.canRemoveItemStack(itemHandler, itemStack, itemStack.field_77994_a)) continue;
                    allItemsPresent = false;
                    break;
                }
                if (allItemsPresent) {
                    for (ItemStack itemStack : requiredItems) {
                        this.removeItemStack(itemHandler, itemStack, itemStack.field_77994_a);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (fluidStack != null) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(EnumFacing.UP, 2));
            if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                IFluidHandler iFluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
                FluidStack removedFluid = iFluidHandler.drain(fluidStack, false);
                if (removedFluid != null && removedFluid.amount == fluidStack.amount) {
                    iFluidHandler.drain(fluidStack, true);
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private void produceOutput() {
        TileEntity te;
        if (!this.processExtraSpawnReq(this.controllerConfig.getMobName(), this.upgradeSetup)) {
            return;
        }
        SpawnerManager.SpawnLoot loot = Woot.spawnerManager.getSpawnerLoot(this.controllerConfig.getMobName(), this.upgradeSetup, this.field_145850_b.func_175649_E(this.func_174877_v()));
        ArrayList<Object> validHandlers = new ArrayList<Object>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        if (this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(f)) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) {
            validHandlers.add(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()));
        }
        validHandlers.addAll(this.proxyManager.getIItemHandlers());
        this.bmOutput(this.upgradeSetup);
        for (IItemHandler iItemHandler : validHandlers) {
            for (ItemStack itemStack : loot.getDropList()) {
                if (itemStack.field_77994_a <= 0) continue;
                boolean success = true;
                while (success && itemStack.field_77994_a > 0) {
                    ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (boolean)false);
                    if (result == null) {
                        --itemStack.field_77994_a;
                        continue;
                    }
                    success = false;
                }
            }
            this.storedXp += loot.getXp();
            int c = this.storedXp / 16;
            if (c == 0) continue;
            ItemStack xpShards = new ItemStack((Item)ModItems.itemXpShard);
            ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)xpShards, (int)c), (boolean)false);
            this.storedXp -= c * 16;
        }
    }

    void onSpawn() {
        if (this.consumedRf >= this.spawnReq.getTotalRf()) {
            this.produceOutput();
            this.setConsumedRf(0);
        } else if (Settings.strictPower) {
            this.setConsumedRf(0);
        }
    }

    public void func_145843_s() {
        this.updateStructureBlocks(false);
        this.updateUpgradeBlocks(false);
        this.proxyManager.setMaster(false);
        super.func_145843_s();
    }

    public void bmKeepAlive() {
        this.bmKeepAlive = true;
    }

    public int bmGetMobCount() {
        return this.bmMobCount;
    }

    public int bmGetSacrificeAmount() {
        return this.bmSacrificeAmount;
    }

    public void bmClear() {
        this.bmMobCount = 0;
        this.bmKeepAlive = false;
        this.bmSacrificeAmount = 0;
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            EnergyManager energyStorage = this.energyManager;
            return (T)((Object)energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

