/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.bloodmagic;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.tile.TileAltar;
import ipsis.woot.tileentity.TileEntityMobFactory;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualInfernalMachine
extends Ritual {
    private static final String RITUAL_INFERNAL_MACHINE = "ritualInfernalMachine";
    private static final int CRYSTAL_LEVEL = 0;
    private static final int ACTIVATION_COST = 40000;
    public static final String ALTAR_RANGE = "altar";
    public static final String FACTORY_RANGE = "factory";
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    public BlockPos factoryOffsetPos = new BlockPos(0, 0, 0);

    public RitualInfernalMachine() {
        super(RITUAL_INFERNAL_MACHINE, 0, 40000, "ritual.Woot:ritualInfernalMachine");
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(FACTORY_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(FACTORY_RANGE, 0, 15, 15);
    }

    private boolean isValidFactory(TileEntity te) {
        TileEntityMobFactory factory;
        return te instanceof TileEntityMobFactory && (factory = (TileEntityMobFactory)te).isFormed() && factory.isRunning();
    }

    private TileEntityMobFactory findFactory(World world, BlockPos pos) {
        BlockPos factoryPos = pos.func_177971_a((Vec3i)this.factoryOffsetPos);
        TileEntity tile = world.func_175625_s(factoryPos);
        AreaDescriptor factoryRange = this.getBlockRange(FACTORY_RANGE);
        if (!factoryRange.isWithinArea(this.factoryOffsetPos) || !this.isValidFactory(tile)) {
            for (BlockPos newPos : factoryRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!this.isValidFactory(nextTile)) continue;
                tile = nextTile;
                this.factoryOffsetPos = newPos.func_177973_b((Vec3i)pos);
                factoryRange.resetCache();
                break;
            }
        }
        return this.isValidFactory(tile) ? (TileEntityMobFactory)tile : null;
    }

    private TileAltar findAltar(World world, BlockPos pos) {
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = this.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        return tile instanceof TileAltar ? (TileAltar)tile : null;
    }

    private int fillAltar(TileAltar te, int mobCount, int sacrificeAmount, int maxEffects) {
        int totalEffects = 0;
        for (int m = 0; m < mobCount; ++m) {
            te.sacrificialDaggerCall(sacrificeAmount, true);
            if (++totalEffects >= maxEffects) break;
        }
        return totalEffects;
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((String)masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        int maxEffects = currentEssence / this.getRefreshCost();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        int effects = 1;
        TileEntityMobFactory teFactory = this.findFactory(world, masterRitualStone.getBlockPos());
        if (teFactory != null) {
            teFactory.bmKeepAlive();
            if (teFactory.bmGetMobCount() > 0) {
                TileAltar teAltar = this.findAltar(world, masterRitualStone.getBlockPos());
                if (teAltar != null) {
                    effects = this.fillAltar(teAltar, teFactory.bmGetMobCount(), teFactory.bmGetSacrificeAmount(), maxEffects);
                }
                teFactory.bmClear();
            }
        }
        network.syphon(this.getRefreshCost() * effects);
    }

    public int getRefreshCost() {
        return 2;
    }

    public int getRefreshTime() {
        return 40;
    }

    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 4, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 2, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        return components;
    }

    public Ritual getNewCopy() {
        return new RitualInfernalMachine();
    }
}

