/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.spawnreq;

import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.manager.UpgradeSetup;
import ipsis.woot.manager.spawnreq.ExtraSpawnReq;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Files;
import ipsis.woot.reference.Settings;
import ipsis.woot.util.SerializationHelper;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpawnReqManager {
    List<ExtraSpawnReq> extraSpawnReqList = new ArrayList<ExtraSpawnReq>();

    void fakeSetup() {
        ExtraSpawnReq req = new ExtraSpawnReq();
        req.setWootName("Woot:none:Sheep");
        req.addItemStack("minecraft:egg", 4);
        req.addItemStack("minecraft:wool:4", 1);
        this.extraSpawnReqList.add(req);
        req = new ExtraSpawnReq();
        req.setWootName("Woot:none:Zombie");
        req.addItemStack("minecraft:apple", 66);
        req.addItemStack("minecraft:iron_ingot", 4);
        this.extraSpawnReqList.add(req);
        req = new ExtraSpawnReq();
        req.setWootName("Woot:none:Spider");
        req.addFluidStack("water", 1000);
        this.extraSpawnReqList.add(req);
        req = new ExtraSpawnReq();
        req.setWootName("Woot:none:Spider");
        req.addFluidStack("liquid_sunshine", 1000);
        this.extraSpawnReqList.add(req);
        SerializationHelper.writeListToFile(this.extraSpawnReqList, Files.spawnReqFile);
    }

    public void loadFromJson() {
        try {
            this.extraSpawnReqList = SerializationHelper.readListFromFile(Files.spawnReqFile);
        }
        catch (FileNotFoundException e) {
            this.extraSpawnReqList = new ArrayList<ExtraSpawnReq>();
        }
        if (this.extraSpawnReqList == null) {
            this.extraSpawnReqList = new ArrayList<ExtraSpawnReq>();
        }
        for (ExtraSpawnReq req : this.extraSpawnReqList) {
            FluidStack fluidStack;
            if (req.hasItems()) {
                LogHelper.info("Added extra req for " + req.getWootName() + "->" + req.getItems());
                continue;
            }
            if (!req.hasFluids() || (fluidStack = req.getFluid()) == null) continue;
            LogHelper.info("Added extra req for " + req.getWootName() + "->" + fluidStack.getUnlocalizedName() + "/" + fluidStack.amount + "mb");
        }
    }

    private ExtraSpawnReq getExtraSpawnReq(String wootName) {
        for (ExtraSpawnReq c : this.extraSpawnReqList) {
            if (!c.getWootName().equalsIgnoreCase(wootName)) continue;
            if (c.hasItems()) {
                return c;
            }
            if (c.hasFluids()) {
                return c;
            }
            return null;
        }
        return null;
    }

    public boolean hasExtraSpawnReq(String wootName) {
        return this.getExtraSpawnReq(wootName) != null;
    }

    public List<ItemStack> getItems(String wootName, UpgradeSetup upgradeSetup) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        ExtraSpawnReq req = this.getExtraSpawnReq(wootName);
        if (req == null) {
            return itemStackList;
        }
        if (!req.hasItems()) {
            return itemStackList;
        }
        int mobCount = Settings.baseMobCount;
        if (upgradeSetup.hasMassUpgrade()) {
            mobCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
        }
        for (ItemStack itemStack : req.getItems()) {
            ItemStack i = itemStack.func_77946_l();
            if (req.getAllowEfficiency() && upgradeSetup.hasEfficiencyUpgrade()) {
                int needed = i.field_77994_a *= mobCount;
                int f = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getEfficiencyUpgrade()).getEfficiency();
                int saving = (int)((float)needed / 100.0f * (float)f);
                i.field_77994_a = needed - saving;
                if (i.field_77994_a <= 0) {
                    i.field_77994_a = 1;
                }
            } else {
                i.field_77994_a *= mobCount;
            }
            itemStackList.add(i);
        }
        return itemStackList;
    }

    public FluidStack getFluid(String wootName, UpgradeSetup upgradeSetup) {
        ExtraSpawnReq req = this.getExtraSpawnReq(wootName);
        if (req == null) {
            return null;
        }
        if (!req.hasFluids()) {
            return null;
        }
        int mobCount = Settings.baseMobCount;
        if (upgradeSetup.hasMassUpgrade()) {
            mobCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
        }
        FluidStack fluidStack = req.getFluid().copy();
        if (req.getAllowEfficiency() && upgradeSetup.hasEfficiencyUpgrade()) {
            int needed = fluidStack.amount * mobCount;
            int f = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getEfficiencyUpgrade()).getEfficiency();
            int saving = (int)((float)needed / 100.0f * (float)f);
            fluidStack.amount = needed - saving;
            if (fluidStack.amount <= 0) {
                fluidStack.amount = 1;
            }
        } else {
            fluidStack.amount *= mobCount;
        }
        return fluidStack;
    }
}

