/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.spawnreq;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.ItemStackHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ExtraSpawnReq {
    private String wootName = "InvalidMob";
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private List<FluidStack> fluids = new ArrayList<FluidStack>();
    private boolean allowEfficiency = true;

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public boolean hasFluids() {
        return !this.hasItems() && !this.fluids.isEmpty();
    }

    public void setWootName(String wootName) {
        this.wootName = wootName;
    }

    public String getWootName() {
        return this.wootName;
    }

    public boolean getAllowEfficiency() {
        return this.allowEfficiency;
    }

    public void setAllowEfficiency(boolean allowEfficiency) {
        this.allowEfficiency = allowEfficiency;
    }

    public void addItemStack(String name, int stackSize) {
        ItemStack itemStack = ItemStackHelper.getItemStackFromName(name);
        if (itemStack != null) {
            itemStack.field_77994_a = stackSize;
            if (itemStack.field_77994_a > itemStack.func_77976_d()) {
                itemStack.field_77994_a = itemStack.func_77976_d();
            }
            this.items.add(itemStack);
        } else {
            LogHelper.info("ExtraSpawnReq: Failed to convert " + name);
        }
    }

    public void addFluidStack(String name, int amount) {
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)name, (int)amount);
        if (fluidStack != null) {
            this.fluids.add(fluidStack);
        } else {
            LogHelper.info("ExtraSpawnReq: Failed to convert " + name);
        }
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    private List<FluidStack> getFluids() {
        if (!this.hasItems()) {
            return this.fluids;
        }
        return new ArrayList<FluidStack>();
    }

    public FluidStack getFluid() {
        if (this.hasItems() || !this.hasFluids()) {
            return null;
        }
        FluidStack f = this.fluids.get(0);
        if (f != null) {
            return f;
        }
        return null;
    }

    public static class Serializer
    implements JsonDeserializer<ExtraSpawnReq>,
    JsonSerializer<ExtraSpawnReq> {
        public ExtraSpawnReq deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int amount;
            JsonElement jsonElement;
            int i;
            JsonObject jsonObject = json.getAsJsonObject();
            String name = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"mob");
            boolean eff = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"efficiency", (boolean)true);
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"items");
            ExtraSpawnReq req = new ExtraSpawnReq();
            req.setWootName(name);
            req.setAllowEfficiency(eff);
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonElement = jsonArray.get(i);
                String itemName = JsonUtils.func_151200_h((JsonObject)jsonElement.getAsJsonObject(), (String)"item");
                amount = JsonUtils.func_151203_m((JsonObject)jsonElement.getAsJsonObject(), (String)"amount");
                req.addItemStack(itemName, amount);
            }
            jsonArray = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"fluids");
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonElement = jsonArray.get(i);
                String fluidName = JsonUtils.func_151200_h((JsonObject)jsonElement.getAsJsonObject(), (String)"fluid");
                amount = JsonUtils.func_151203_m((JsonObject)jsonElement.getAsJsonObject(), (String)"amount");
                req.addFluidStack(fluidName, amount);
            }
            return req;
        }

        public JsonElement serialize(ExtraSpawnReq src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("mob", src.getWootName());
            jsonObject.addProperty("efficiency", Boolean.valueOf(src.getAllowEfficiency()));
            jsonObject.add("items", context.serialize((Object)src.items));
            jsonObject.add("fluids", context.serialize((Object)src.fluids));
            return jsonObject;
        }
    }

    public static class FluidStackSerializer
    implements JsonSerializer<FluidStack> {
        public JsonElement serialize(FluidStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluid", FluidRegistry.getFluidName((Fluid)src.getFluid()));
            jsonObject.addProperty("amount", (Number)src.amount);
            return jsonObject;
        }
    }

    public static class ItemStackSerializer
    implements JsonSerializer<ItemStack> {
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ItemStackHelper.getItemStackName(src));
            jsonObject.addProperty("amount", (Number)src.field_77994_a);
            return jsonObject;
        }
    }
}

