/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.loot;

import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.MobRegistry;
import ipsis.woot.manager.loot.FullDropInfo;
import ipsis.woot.manager.loot.LootEnderDragon;
import ipsis.woot.manager.loot.LootTable;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Files;
import ipsis.woot.reference.Settings;
import ipsis.woot.util.ItemStackHelper;
import ipsis.woot.util.SerializationHelper;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class LootTableManager {
    private HashMap<String, LootTable> lootMap = new HashMap();
    private List<ItemStack> blacklist = new ArrayList<ItemStack>();
    private List<ItemStack> internalBlacklist = new ArrayList<ItemStack>();
    private List<String> internalModBlacklist = new ArrayList<String>();
    private LootEnderDragon lootEnderDragon = new LootEnderDragon();

    public void loadInternalBlacklist() {
        this.addToInternalModBlacklist("eplus");
        this.addToInternalModBlacklist("everlastingabilities");
        this.addToInternalModBlacklist("cyberware");
    }

    public void loadDragonDrops() {
        this.lootEnderDragon.addDrops();
    }

    private void addToInternalModBlacklist(String s) {
        this.internalModBlacklist.add(s);
        LogHelper.info("Blacklisted (Internal) all items from " + s);
    }

    private void addToInternalBlacklist(String s) {
        ItemStack itemStack = ItemStackHelper.getItemStackFromName(s);
        if (itemStack != null) {
            LogHelper.warn("Blacklisted (Internal) item " + s);
            this.internalBlacklist.add(itemStack);
        } else {
            LogHelper.warn("Unknown Loot in blacklist (Internal) " + s);
        }
    }

    public void addToBlacklist(String s) {
        ItemStack itemStack = ItemStackHelper.getItemStackFromName(s);
        if (itemStack != null) {
            LogHelper.warn("Blacklisted (User) item " + s);
            this.blacklist.add(itemStack);
        } else {
            LogHelper.warn("Unknown Loot in blacklist " + s);
        }
    }

    public boolean isBlacklisted(ItemStack itemStack) {
        String firstMod;
        ResourceLocation first = itemStack.func_77973_b().getRegistryName();
        if (first != null && (firstMod = first.func_110624_b()) != null) {
            for (String s : this.internalModBlacklist) {
                if (!firstMod.equals(s)) continue;
                return true;
            }
        }
        for (ItemStack cmp : this.blacklist) {
            if (!ItemStack.func_185132_d((ItemStack)cmp, (ItemStack)itemStack)) continue;
            return true;
        }
        for (ItemStack cmp : this.internalBlacklist) {
            if (!ItemStack.func_185132_d((ItemStack)cmp, (ItemStack)itemStack)) continue;
            return true;
        }
        return false;
    }

    public void update(String wootName, EnumEnchantKey key, List<EntityItem> mobDropList, boolean updateCount) {
        LootTable e = this.lootMap.get(wootName);
        if (e == null) {
            e = new LootTable(wootName);
            this.lootMap.put(wootName, e);
        }
        e.update(key, mobDropList, updateCount);
    }

    public List<ItemStack> getDrops(String wootName, EnumEnchantKey key) {
        if (MobRegistry.isEnderDragon(wootName)) {
            return this.lootEnderDragon.getDrops(key);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        LootTable e = this.lootMap.get(wootName);
        if (e != null) {
            e.getDrops(key, drops);
        }
        return drops;
    }

    public List<FullDropInfo> getFullDropInfo(String wootName, EnumEnchantKey key) {
        if (MobRegistry.isEnderDragon(wootName)) {
            return this.lootEnderDragon.getFullDropInfo(key);
        }
        List<FullDropInfo> drops = null;
        LootTable e = this.lootMap.get(wootName);
        if (e != null) {
            drops = e.getFullDropInfo(key);
        }
        return drops;
    }

    public boolean isFull(String wootName, EnumEnchantKey key) {
        if (MobRegistry.isEnderDragon(wootName)) {
            return true;
        }
        LootTable e = this.lootMap.get(wootName);
        if (e == null) {
            return false;
        }
        return e.isFull(key);
    }

    public boolean isEmpty(String wootName, EnumEnchantKey key) {
        if (MobRegistry.isEnderDragon(wootName)) {
            return false;
        }
        LootTable e = this.lootMap.get(wootName);
        if (e == null) {
            return true;
        }
        return e.isEmpty(key);
    }

    public void dumpMobs(ICommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (String mobName : this.lootMap.keySet()) {
            sb.append(mobName).append(" ");
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.mobs.summary", new Object[]{sb}));
    }

    public void dumpDrops(ICommandSender sender, String wootName, boolean detail) {
        LootTable e = this.lootMap.get(wootName);
        if (e != null) {
            for (EnumEnchantKey key : EnumEnchantKey.values()) {
                String s = e.getDrops(key, detail);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.loot.summary", new Object[]{wootName, key.getDisplayName(), s}));
            }
        }
    }

    public void flushMob(ICommandSender sender, String wootName, EnumEnchantKey key) {
        LootTable e = this.lootMap.get(wootName);
        if (e != null) {
            e.flush(key);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.flush.summary", new Object[]{wootName, key.getDisplayName()}));
        }
    }

    public void flushAllMobs(ICommandSender sender) {
        for (LootTable table : this.lootMap.values()) {
            table.flush(EnumEnchantKey.NO_ENCHANT);
            table.flush(EnumEnchantKey.LOOTING_I);
            table.flush(EnumEnchantKey.LOOTING_II);
            table.flush(EnumEnchantKey.LOOTING_III);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.flush.all.summary", new Object[0]));
    }

    public void dumpBlacklist(ICommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (ItemStack itemStack : this.blacklist) {
            sb.append(String.format("%s ", itemStack.func_82833_r()));
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.blacklist.summary", new Object[]{sb.toString()}));
    }

    public void dumpStatus(ICommandSender sender) {
        for (String mob : this.lootMap.keySet()) {
            StringBuilder sb = new StringBuilder();
            for (EnumEnchantKey key : EnumEnchantKey.values()) {
                int samples = this.lootMap.get(mob).getSamples(key);
                sb.append(" " + key.ordinal() + ":" + samples + "/" + Settings.sampleSize + " ");
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.status.summary", new Object[]{mob, sb.toString()}));
        }
    }

    public void load() {
        LogHelper.info("LootTableManager: Load loot statistics from " + Files.getWootFileForDisplay());
        this.lootMap = null;
        try {
            this.lootMap = SerializationHelper.readHashMapFromFile(Files.lootFile);
        }
        catch (FileNotFoundException e) {
            this.lootMap = new HashMap();
        }
        if (this.lootMap == null) {
            this.lootMap = new HashMap();
        }
    }

    public void save() {
        LogHelper.info("LootTableManager: Save loot statistics to " + Files.getWootFileForDisplay());
        SerializationHelper.writeHashMapToFile(this.lootMap, Files.lootFile);
    }
}

