/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ipsis.Woot;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.loot.Drop;
import ipsis.woot.manager.loot.FullDropInfo;
import ipsis.woot.manager.loot.LootPool;
import ipsis.woot.reference.Settings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class LootTable {
    String mobName;
    LootPool[] pools;

    public LootTable(String mobName) {
        this.mobName = mobName;
        this.pools = new LootPool[EnumEnchantKey.values().length];
        for (EnumEnchantKey k : EnumEnchantKey.values()) {
            this.pools[k.ordinal()] = new LootPool(k);
        }
    }

    public LootTable(String mobName, LootPool[] pools) {
        this.mobName = mobName;
        this.pools = pools;
    }

    public boolean isFull(EnumEnchantKey key) {
        LootPool pool = this.getLootPool(key);
        return pool.samples >= Settings.sampleSize;
    }

    public boolean isEmpty(EnumEnchantKey key) {
        LootPool pool = this.getLootPool(key);
        return pool.samples == 0;
    }

    public int getSamples(EnumEnchantKey key) {
        LootPool pool = this.getLootPool(key);
        return pool.samples;
    }

    private LootPool getLootPool(EnumEnchantKey key) {
        return this.pools[key.ordinal()];
    }

    public void flush(EnumEnchantKey key) {
        this.pools[key.ordinal()] = new LootPool(key);
    }

    public void update(EnumEnchantKey key, List<EntityItem> drops, boolean updateCount) {
        LootPool pool = this.getLootPool(key);
        if (updateCount) {
            ++pool.samples;
        }
        for (EntityItem entityItem : drops) {
            ItemStack itemStack = entityItem.func_92059_d();
            boolean found = false;
            for (Drop d : pool.drops) {
                if (!d.itemStack.func_185136_b(itemStack)) continue;
                d.update(itemStack.field_77994_a);
                found = true;
                break;
            }
            if (found) continue;
            Drop d = new Drop(itemStack);
            d.update(itemStack.field_77994_a);
            pool.drops.add(d);
        }
    }

    public void getDrops(EnumEnchantKey key, List<ItemStack> loot) {
        LootPool pool = this.getLootPool(key);
        for (Drop d : pool.drops) {
            float chance = Woot.RANDOM.nextFloat();
            if (!(chance <= d.getChance(pool.samples)) || Item.func_150898_a((Block)Blocks.field_150357_h) == d.itemStack.func_77973_b() || Woot.LOOT_TABLE_MANAGER.isBlacklisted(d.itemStack)) continue;
            ItemStack dropStack = ItemStack.func_77944_b((ItemStack)d.itemStack);
            dropStack.field_77994_a = d.getWeightedSize();
            if (dropStack.func_77984_f()) {
                int dmg = Woot.RANDOM.nextInt(dropStack.func_77958_k()) + 1;
                dropStack.func_77964_b(dmg);
            }
            loot.add(dropStack);
        }
    }

    public String getDrops(EnumEnchantKey key, boolean detail) {
        StringBuilder sb = new StringBuilder();
        LootPool pool = this.getLootPool(key);
        sb.append(pool.samples).append(" ");
        for (Drop d : pool.drops) {
            float chance = d.getChance(pool.samples) * 100.0f;
            sb.append(String.format("[ %dx%s @ %.2f%%", d.count, d.itemStack.func_82833_r(), Float.valueOf(chance)));
            if (detail) {
                sb.append(" ");
                for (Drop.DropData dd : d.weights) {
                    sb.append(String.format("(s%d:w%d)", dd.stackSize, dd.field_76292_a));
                }
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    public List<FullDropInfo> getFullDropInfo(EnumEnchantKey key) {
        ArrayList<FullDropInfo> info = new ArrayList<FullDropInfo>();
        LootPool pool = this.getLootPool(key);
        for (Drop d : pool.drops) {
            float chance = d.getChance(pool.samples) * 100.0f;
            if (d.itemStack == null) continue;
            info.add(new FullDropInfo(d.itemStack.func_77946_l(), chance));
        }
        return info;
    }

    public static class Serializer
    implements JsonSerializer<LootTable>,
    JsonDeserializer<LootTable> {
        public LootTable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"table");
            String mobName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"mob");
            LootPool[] pools = jsonObject.has("pools") ? (LootPool[])JsonUtils.func_188174_a((JsonObject)jsonObject, (String)"pools", (JsonDeserializationContext)context, LootPool[].class) : new LootPool[]{};
            LootTable lootTable = new LootTable(mobName);
            lootTable.pools = pools;
            return lootTable;
        }

        public JsonElement serialize(LootTable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("mob", src.mobName);
            jsonObject.add("pools", context.serialize((Object)src.pools));
            return jsonObject;
        }
    }
}

