/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.loot;

import ipsis.Woot;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.loot.FullDropInfo;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Settings;
import ipsis.woot.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class LootEnderDragon {
    private HashMap<EnumEnchantKey, List<DragonDrop>> dropMap = new HashMap();

    public LootEnderDragon() {
        this.dropMap.put(EnumEnchantKey.NO_ENCHANT, new ArrayList());
        this.dropMap.put(EnumEnchantKey.LOOTING_I, new ArrayList());
        this.dropMap.put(EnumEnchantKey.LOOTING_II, new ArrayList());
        this.dropMap.put(EnumEnchantKey.LOOTING_III, new ArrayList());
    }

    public void addDrops() {
        for (int i = 0; i < Settings.dragonDropList.length; ++i) {
            this.addDrop(Settings.dragonDropList[i]);
        }
    }

    private void addDrop(String drop) {
        String[] parts = drop.split(",");
        if (parts.length == 4) {
            try {
                EnumEnchantKey key = EnumEnchantKey.getFromString(parts[0]);
                String item = parts[1];
                int stackSize = Integer.parseInt(parts[2]);
                float chance = Float.parseFloat(parts[3]);
                ItemStack itemStack = ItemStackHelper.getItemStackFromName(item);
                if (itemStack != null && stackSize > 0 && chance > 0.0f && chance <= 100.0f) {
                    itemStack.field_77994_a = stackSize;
                    LogHelper.info("Added Ender Dragon drop - " + item + "/" + stackSize + "@" + chance + "%%");
                    this.dropMap.get((Object)key).add(new DragonDrop(itemStack, chance));
                }
            }
            catch (NumberFormatException e) {
                LogHelper.error("Invalid dragon drop - key,item,meta,stacksize,chance: " + drop);
            }
        } else {
            LogHelper.error("Invalid dragon drop - key,item,meta,stacksize,chance: " + drop);
        }
    }

    public List<ItemStack> getDrops(EnumEnchantKey key) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (DragonDrop i : this.dropMap.get((Object)key)) {
            float chance = Woot.RANDOM.nextFloat();
            if (!(chance <= i.chance / 100.0f)) continue;
            drops.add(i.itemStack.func_77946_l());
        }
        return drops;
    }

    public List<FullDropInfo> getFullDropInfo(EnumEnchantKey key) {
        ArrayList<FullDropInfo> drops = new ArrayList<FullDropInfo>();
        for (DragonDrop i : this.dropMap.get((Object)key)) {
            drops.add(new FullDropInfo(i.itemStack.func_77946_l(), i.chance));
        }
        return drops;
    }

    static class DragonDrop {
        float chance;
        ItemStack itemStack;

        public DragonDrop(ItemStack itemStack, float chance) {
            this.chance = chance;
            this.itemStack = itemStack.func_77946_l();
        }
    }
}

