/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ipsis.Woot;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.ItemStackHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.WeightedRandom;

public class Drop {
    ItemStack itemStack;
    int count;
    List<DropData> weights;

    public float getChance(int sampleSize) {
        if (sampleSize == 0) {
            return 0.0f;
        }
        int realcount = this.count;
        if (realcount > sampleSize) {
            realcount = sampleSize;
        }
        return (float)realcount / (float)sampleSize;
    }

    public Drop(ItemStack itemStack) {
        this.itemStack = ItemStack.func_77944_b((ItemStack)itemStack);
        this.count = 0;
        this.weights = new ArrayList<DropData>();
    }

    public void update(int stackSize) {
        ++this.count;
        boolean found = false;
        for (DropData dropData : this.weights) {
            if (dropData.stackSize != stackSize) continue;
            dropData.incItemWeight();
            found = true;
        }
        if (!found) {
            this.weights.add(new DropData(stackSize, 1));
        }
    }

    public int getWeightedSize() {
        DropData dropData = (DropData)WeightedRandom.func_76271_a((Random)Woot.RANDOM, this.weights);
        if (dropData != null) {
            return dropData.stackSize;
        }
        return 1;
    }

    public static class DropData
    extends WeightedRandom.Item {
        public final int stackSize;

        public DropData(int stackSize, int itemWeight) {
            super(itemWeight);
            this.stackSize = stackSize;
        }

        public void incItemWeight() {
            ++this.field_76292_a;
        }

        public static class Serializer
        implements JsonSerializer<DropData>,
        JsonDeserializer<DropData> {
            public DropData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"drop data");
                int stackSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"stack_size", (int)1);
                int weight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"weight", (int)1);
                return new DropData(stackSize, weight);
            }

            public JsonElement serialize(DropData src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("stack_size", (Number)src.stackSize);
                jsonObject.addProperty("weight", (Number)src.field_76292_a);
                return jsonObject;
            }
        }
    }

    public static class Serializer
    implements JsonSerializer<Drop>,
    JsonDeserializer<Drop> {
        public Drop deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"drop");
            String itemName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"item");
            ItemStack itemStack = ItemStackHelper.getItemStackFromName(itemName);
            if (itemStack == null) {
                LogHelper.warn("Invalid loot item name '" + itemName + "'");
                itemStack = new ItemStack(Blocks.field_150357_h);
            }
            int count = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"count");
            DropData[] weights = jsonObject.has("weights") ? (DropData[])JsonUtils.func_188174_a((JsonObject)jsonObject, (String)"weights", (JsonDeserializationContext)context, DropData[].class) : new DropData[]{};
            Drop drop = new Drop(itemStack);
            drop.count = count;
            Collections.addAll(drop.weights, weights);
            return drop;
        }

        public JsonElement serialize(Drop src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            String itemName = ItemStackHelper.getItemStackName(src.itemStack);
            if (itemName == null) {
                throw new JsonParseException("Cannot create itemname from stack");
            }
            jsonObject.addProperty("item", itemName);
            jsonObject.addProperty("count", (Number)src.count);
            jsonObject.add("weights", context.serialize(src.weights));
            return jsonObject;
        }
    }
}

