/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.reference.Settings;
import java.util.ArrayList;
import java.util.List;

public class UpgradeSetup {
    EnumEnchantKey enchantKey;
    EnumSpawnerUpgrade rateUpgrade;
    EnumSpawnerUpgrade lootingUpgrade;
    EnumSpawnerUpgrade xpUpgrade;
    EnumSpawnerUpgrade massUpgrade;
    EnumSpawnerUpgrade decapitateUpgrade;
    EnumSpawnerUpgrade efficiencyUpgrade;
    EnumSpawnerUpgrade bmUpgrade;
    List<EnumSpawnerUpgrade> upgradeList = new ArrayList<EnumSpawnerUpgrade>();
    int rfPerTickCost;

    public UpgradeSetup() {
        this.clear();
    }

    public void clear() {
        this.enchantKey = EnumEnchantKey.NO_ENCHANT;
        this.rateUpgrade = null;
        this.lootingUpgrade = null;
        this.xpUpgrade = null;
        this.massUpgrade = null;
        this.decapitateUpgrade = null;
        this.efficiencyUpgrade = null;
        this.bmUpgrade = null;
        this.upgradeList.clear();
    }

    private int calcUpgradeCost(int tier, int tICost, int tIICost, int tIIICost) {
        if (tier == 1) {
            return tICost;
        }
        if (tier == 2) {
            return tIICost;
        }
        return tIIICost;
    }

    public void processUpgrades(List<SpawnerUpgrade> upgradeList) {
        this.clear();
        this.enchantKey = UpgradeManager.getLootingEnchant(upgradeList);
        this.rfPerTickCost = 0;
        SpawnerUpgrade u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.MASS);
        if (u != null) {
            this.massUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.massUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.massIRfTick, Settings.massIIRfTick, Settings.massIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.RATE)) != null) {
            this.rateUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.rateUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.rateIRfTick, Settings.rateIIRfTick, Settings.rateIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.DECAPITATE)) != null) {
            this.decapitateUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.decapitateUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.decapitateIRfTick, Settings.decapitateIIRfTick, Settings.decapitateIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.LOOTING)) != null) {
            this.lootingUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.lootingUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.lootingIRfTick, Settings.lootingIIRfTick, Settings.lootingIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.XP)) != null) {
            this.xpUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.xpUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.xpIRfTick, Settings.xpIIRfTick, Settings.xpIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.BLOOD_MAGIC)) != null) {
            this.bmUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.bmUpgrade);
            this.rfPerTickCost += this.calcUpgradeCost(u.getUpgradeTier(), Settings.bmIRfTick, Settings.bmIIRfTick, Settings.bmIIIRfTick);
        }
        if ((u = UpgradeManager.getUpgrade(upgradeList, UpgradeManager.EnumUpgradeType.EFFICIENCY)) != null) {
            this.efficiencyUpgrade = u.getUpgradeType();
            this.upgradeList.add(this.efficiencyUpgrade);
        }
    }

    public boolean hasBmUpgrade() {
        return this.bmUpgrade != null;
    }

    public boolean hasMassUpgrade() {
        return this.massUpgrade != null;
    }

    public boolean hasRateUpgrade() {
        return this.rateUpgrade != null;
    }

    public boolean hasDecapitateUpgrade() {
        return this.decapitateUpgrade != null;
    }

    public boolean hasLootingUpgrade() {
        return this.lootingUpgrade != null;
    }

    public boolean hasXpUpgrade() {
        return this.xpUpgrade != null;
    }

    public boolean hasEfficiencyUpgrade() {
        return this.efficiencyUpgrade != null;
    }

    public List<EnumSpawnerUpgrade> getUpgradeList() {
        return this.upgradeList;
    }

    public int getRfPerTickCost() {
        return this.rfPerTickCost;
    }

    public EnumSpawnerUpgrade getMassUpgrade() {
        return this.massUpgrade;
    }

    public EnumSpawnerUpgrade getRateUpgrade() {
        return this.rateUpgrade;
    }

    public EnumSpawnerUpgrade getDecapitateUpgrade() {
        return this.decapitateUpgrade;
    }

    public EnumSpawnerUpgrade getLootingUpgrade() {
        return this.lootingUpgrade;
    }

    public EnumSpawnerUpgrade getXpUpgrade() {
        return this.xpUpgrade;
    }

    public EnumSpawnerUpgrade getEfficiencyUpgrade() {
        return this.efficiencyUpgrade;
    }

    public EnumSpawnerUpgrade getBmUpgrade() {
        return this.bmUpgrade;
    }

    public EnumEnchantKey getEnchantKey() {
        return this.enchantKey;
    }
}

