/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.woot.block.BlockMobFactoryUpgrade;
import ipsis.woot.block.BlockMobFactoryUpgradeB;
import ipsis.woot.block.EnumVariantUpgrade;
import ipsis.woot.block.EnumVariantUpgradeB;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.reference.Settings;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class UpgradeManager {
    static HashMap<EnumSpawnerUpgrade, SpawnerUpgrade> upgradeMap = new HashMap();

    public static void loadConfig() {
        upgradeMap.get((Object)EnumSpawnerUpgrade.RATE_I).setRfCostPerTick(Settings.rateIRfTick).setSpawnRate(Settings.rateITicks);
        upgradeMap.get((Object)EnumSpawnerUpgrade.RATE_II).setRfCostPerTick(Settings.rateIIRfTick).setSpawnRate(Settings.rateIITicks);
        upgradeMap.get((Object)EnumSpawnerUpgrade.RATE_III).setRfCostPerTick(Settings.rateIIIRfTick).setSpawnRate(Settings.rateIIITicks);
        upgradeMap.get((Object)EnumSpawnerUpgrade.LOOTING_I).setRfCostPerTick(Settings.lootingIRfTick);
        upgradeMap.get((Object)EnumSpawnerUpgrade.LOOTING_II).setRfCostPerTick(Settings.lootingIIRfTick);
        upgradeMap.get((Object)EnumSpawnerUpgrade.LOOTING_III).setRfCostPerTick(Settings.lootingIIIRfTick);
        upgradeMap.get((Object)EnumSpawnerUpgrade.XP_I).setRfCostPerTick(Settings.xpIRfTick).setXpBoost(Settings.xpIBoost);
        upgradeMap.get((Object)EnumSpawnerUpgrade.XP_II).setRfCostPerTick(Settings.xpIIRfTick).setXpBoost(Settings.xpIIBoost);
        upgradeMap.get((Object)EnumSpawnerUpgrade.XP_III).setRfCostPerTick(Settings.xpIIIRfTick).setXpBoost(Settings.xpIIIBoost);
        upgradeMap.get((Object)EnumSpawnerUpgrade.MASS_I).setRfCostPerTick(Settings.massIRfTick).setMass(Settings.massIMobs);
        upgradeMap.get((Object)EnumSpawnerUpgrade.MASS_II).setRfCostPerTick(Settings.massIIRfTick).setMass(Settings.massIIMobs);
        upgradeMap.get((Object)EnumSpawnerUpgrade.MASS_III).setRfCostPerTick(Settings.massIIIRfTick).setMass(Settings.massIIIMobs);
        upgradeMap.get((Object)EnumSpawnerUpgrade.DECAPITATE_I).setRfCostPerTick(Settings.decapitateIRfTick).setDecapitateChance(Settings.decapitateIChance);
        upgradeMap.get((Object)EnumSpawnerUpgrade.DECAPITATE_II).setRfCostPerTick(Settings.decapitateIIRfTick).setDecapitateChance(Settings.decapitateIIChance);
        upgradeMap.get((Object)EnumSpawnerUpgrade.DECAPITATE_III).setRfCostPerTick(Settings.decapitateIIIRfTick).setDecapitateChance(Settings.decapitateIIIChance);
        upgradeMap.get((Object)EnumSpawnerUpgrade.EFFICIENCY_I).setRfCostPerTick(0).setEfficiency(Settings.efficiencyI);
        upgradeMap.get((Object)EnumSpawnerUpgrade.EFFICIENCY_II).setRfCostPerTick(0).setEfficiency(Settings.efficiencyII);
        upgradeMap.get((Object)EnumSpawnerUpgrade.EFFICIENCY_III).setRfCostPerTick(0).setEfficiency(Settings.efficiencyIII);
        upgradeMap.get((Object)EnumSpawnerUpgrade.BLOODMAGIC_I).setRfCostPerTick(Settings.bmIRfTick).setSacrificeCount(Settings.bmICount).setAltarLifeEssence(Settings.bmIAltarLifeEssence);
        upgradeMap.get((Object)EnumSpawnerUpgrade.BLOODMAGIC_II).setRfCostPerTick(Settings.bmIIRfTick).setSacrificeCount(Settings.bmIICount).setAltarLifeEssence(Settings.bmIIAltarLifeEssence);
        upgradeMap.get((Object)EnumSpawnerUpgrade.BLOODMAGIC_III).setRfCostPerTick(Settings.bmIIIRfTick).setSacrificeCount(Settings.bmIIICount).setAltarLifeEssence(Settings.bmIIIAltarLifeEssence);
    }

    public static EnumEnchantKey getLootingEnchant(List<SpawnerUpgrade> upgradeList) {
        int tier = 0;
        EnumEnchantKey enchantKey = EnumEnchantKey.NO_ENCHANT;
        for (SpawnerUpgrade upgrade : upgradeList) {
            if (!upgrade.isLooting() || upgrade.getUpgradeTier() <= tier) continue;
            enchantKey = upgrade.getEnchantKey();
            tier = upgrade.getUpgradeTier();
        }
        return enchantKey;
    }

    static boolean isUpgradeMatch(SpawnerUpgrade u, EnumUpgradeType type) {
        switch (type) {
            case LOOTING: {
                return u.isLooting();
            }
            case MASS: {
                return u.isMass();
            }
            case RATE: {
                return u.isRate();
            }
            case DECAPITATE: {
                return u.isDecapitate();
            }
            case XP: {
                return u.isXp();
            }
            case EFFICIENCY: {
                return u.isEfficiency();
            }
            case BLOOD_MAGIC: {
                return u.isBloodMagic();
            }
        }
        return false;
    }

    public static SpawnerUpgrade getUpgrade(List<SpawnerUpgrade> upgradeList, EnumUpgradeType type) {
        SpawnerUpgrade spawnerUpgrade = null;
        int tier = 0;
        for (SpawnerUpgrade upgrade : upgradeList) {
            if (!UpgradeManager.isUpgradeMatch(upgrade, type) || upgrade.getUpgradeTier() <= tier) continue;
            tier = upgrade.getUpgradeTier();
            spawnerUpgrade = upgrade;
        }
        return spawnerUpgrade;
    }

    static boolean isUpgradeBlock(Block b) {
        return b instanceof BlockMobFactoryUpgrade || b instanceof BlockMobFactoryUpgradeB;
    }

    static EnumSpawnerUpgrade getUpgradeFromBlockState(IBlockState iBlockState, Block b) {
        if (b instanceof BlockMobFactoryUpgrade) {
            return EnumSpawnerUpgrade.getFromVariant((EnumVariantUpgrade)((Object)iBlockState.func_177229_b(BlockMobFactoryUpgrade.VARIANT)));
        }
        if (b instanceof BlockMobFactoryUpgradeB) {
            return EnumSpawnerUpgrade.getFromVariant((EnumVariantUpgradeB)((Object)iBlockState.func_177229_b(BlockMobFactoryUpgradeB.VARIANT)));
        }
        return null;
    }

    public static List<SpawnerUpgrade> scanUpgradeTotem(World world, BlockPos blockPos, int maxTier, List<SpawnerUpgrade> upgradeList, List<BlockPos> blockPosList) {
        EnumSpawnerUpgrade u;
        IBlockState iBlockState;
        Block block;
        if (!world.func_175667_e(blockPos) || maxTier <= 0) {
            return upgradeList;
        }
        EnumSpawnerUpgrade firstUpgrade = null;
        for (int yOffset = 0; yOffset < maxTier && UpgradeManager.isUpgradeBlock(block = (iBlockState = world.func_180495_p(blockPos.func_177982_a(0, yOffset, 0))).func_177230_c()) && (u = UpgradeManager.getUpgradeFromBlockState(iBlockState, block)) != null; ++yOffset) {
            if (firstUpgrade == null) {
                firstUpgrade = u;
            } else if (!UpgradeManager.checkUpgrade(firstUpgrade, u)) break;
            SpawnerUpgrade tmpUpgrade = upgradeMap.get((Object)u);
            if (tmpUpgrade.getUpgradeTier() != yOffset + 1) break;
            upgradeList.add(tmpUpgrade);
            blockPosList.add(new BlockPos((Vec3i)blockPos.func_177982_a(0, yOffset, 0)));
        }
        return upgradeList;
    }

    static boolean checkUpgrade(EnumSpawnerUpgrade first, EnumSpawnerUpgrade u) {
        if (first == EnumSpawnerUpgrade.RATE_I) {
            return u == EnumSpawnerUpgrade.RATE_II || u == EnumSpawnerUpgrade.RATE_III;
        }
        if (first == EnumSpawnerUpgrade.DECAPITATE_I) {
            return u == EnumSpawnerUpgrade.DECAPITATE_II || u == EnumSpawnerUpgrade.DECAPITATE_III;
        }
        if (first == EnumSpawnerUpgrade.LOOTING_I) {
            return u == EnumSpawnerUpgrade.LOOTING_II || u == EnumSpawnerUpgrade.LOOTING_III;
        }
        if (first == EnumSpawnerUpgrade.MASS_I) {
            return u == EnumSpawnerUpgrade.MASS_II || u == EnumSpawnerUpgrade.MASS_III;
        }
        if (first == EnumSpawnerUpgrade.XP_I) {
            return u == EnumSpawnerUpgrade.XP_II || u == EnumSpawnerUpgrade.XP_III;
        }
        if (first == EnumSpawnerUpgrade.EFFICIENCY_I) {
            return u == EnumSpawnerUpgrade.EFFICIENCY_II || u == EnumSpawnerUpgrade.EFFICIENCY_III;
        }
        if (first == EnumSpawnerUpgrade.BLOODMAGIC_I) {
            return u == EnumSpawnerUpgrade.BLOODMAGIC_II || u == EnumSpawnerUpgrade.BLOODMAGIC_III;
        }
        return false;
    }

    public static SpawnerUpgrade getSpawnerUpgrade(EnumSpawnerUpgrade u) {
        return upgradeMap.get((Object)u);
    }

    static {
        for (EnumSpawnerUpgrade u : EnumSpawnerUpgrade.values()) {
            upgradeMap.put(u, new SpawnerUpgrade(u));
        }
    }

    public static enum EnumUpgradeType {
        LOOTING,
        MASS,
        RATE,
        DECAPITATE,
        XP,
        EFFICIENCY,
        BLOOD_MAGIC;

    }
}

