/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.Woot;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TierMapper {
    Map<String, EnumMobFactoryTier> mapper = new TreeMap<String, EnumMobFactoryTier>(String.CASE_INSENSITIVE_ORDER);

    public EnumMobFactoryTier getTierForEntity(String entityName, int xp) {
        EnumMobFactoryTier tier = this.mapper.get(entityName);
        if (tier == null) {
            tier = xp <= Settings.tierIMobXpCap ? EnumMobFactoryTier.TIER_ONE : (xp <= Settings.tierIIMobXpCap ? EnumMobFactoryTier.TIER_TWO : (xp <= Settings.tierIIIMobXpCap ? EnumMobFactoryTier.TIER_THREE : EnumMobFactoryTier.TIER_FOUR));
        }
        return tier;
    }

    public boolean isTierValid(String entityName, int xp, EnumMobFactoryTier tier) {
        boolean valid = false;
        EnumMobFactoryTier correctTier = this.getTierForEntity(entityName, xp);
        switch (correctTier) {
            case TIER_ONE: {
                valid = true;
                break;
            }
            case TIER_TWO: {
                valid = tier == EnumMobFactoryTier.TIER_TWO || tier == EnumMobFactoryTier.TIER_THREE || tier == EnumMobFactoryTier.TIER_FOUR;
                break;
            }
            case TIER_THREE: {
                valid = tier == EnumMobFactoryTier.TIER_THREE || tier == EnumMobFactoryTier.TIER_FOUR;
                break;
            }
            case TIER_FOUR: {
                valid = tier == EnumMobFactoryTier.TIER_FOUR;
            }
        }
        return valid;
    }

    public void addMapping(String entityName, EnumMobFactoryTier t) {
        if (Woot.mobRegistry.isValidMobName(entityName)) {
            LogHelper.info("Adding tier mapping " + entityName + "->" + (Object)((Object)t));
            this.mapper.put(entityName, t);
        }
    }

    public void cmdDumpTiers(ICommandSender sender) {
        for (String mobName : this.mapper.keySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.tiers.summary", new Object[]{mobName, this.mapper.get(mobName).getTranslated("waila.Woot:controller.tier")}));
        }
    }
}

