/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.Woot;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.manager.UpgradeSetup;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.FakePlayerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class SpawnerManager {
    public SpawnReq getSpawnReq(String mobName, UpgradeSetup upgradeSetup, TileEntityMobFactory te, EnumMobFactoryTier tier) {
        int f;
        int saving;
        if (!Woot.mobRegistry.isValidMobName(mobName)) {
            return null;
        }
        int xpLevel = this.getSpawnXp(mobName, te);
        int baseRF = tier == EnumMobFactoryTier.TIER_ONE ? Settings.tierIRFtick : (tier == EnumMobFactoryTier.TIER_TWO ? Settings.tierIIRFtick : (tier == EnumMobFactoryTier.TIER_THREE ? Settings.tierIIIRFtick : Settings.tierIVRFtick));
        int xpPerTick = Settings.xpRFtick;
        int mobCount = upgradeSetup.hasMassUpgrade() ? UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass() : 1;
        int spawnTime = upgradeSetup.hasRateUpgrade() ? UpgradeManager.getSpawnerUpgrade(upgradeSetup.getRateUpgrade()).getSpawnRate() : Settings.baseRateTicks;
        int RFt = baseRF * Settings.baseRateTicks;
        int RFmob = xpPerTick * xpLevel * Settings.baseRateTicks;
        int RFupgrade = upgradeSetup.getRfPerTickCost() * Settings.baseRateTicks;
        int RFcount = RFmob + (int)((double)RFmob * 0.33) * (mobCount - 1);
        int RFtotal = RFt + RFcount + RFupgrade;
        if (upgradeSetup.hasEfficiencyUpgrade() && (RFtotal -= (saving = (int)((float)RFtotal / 100.0f * (float)(f = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getEfficiencyUpgrade()).getEfficiency())))) < 0) {
            RFtotal = 1;
        }
        return new SpawnReq(RFtotal, spawnTime);
    }

    public int getSpawnXp(String mobName, TileEntity te) {
        if (!Woot.mobRegistry.hasXp(mobName)) {
            Entity entity = this.spawnEntity(mobName, te.func_145831_w(), te.func_174877_v(), false);
            if (entity != null) {
                int xp = ((EntityLiving)entity).field_70728_aV;
                Woot.mobRegistry.addMapping(mobName, xp);
            }
            Object var3_3 = null;
        }
        return Woot.mobRegistry.getSpawnXp(mobName);
    }

    private void createLootBox(World world, BlockPos originPos) {
        Block b = Blocks.field_180401_cv;
        for (int y = 251; y <= 255; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos p;
                    boolean change = false;
                    if (y == 255 || y == 251) {
                        change = true;
                    } else if (x == -2 || x == 2 || z == -2 || z == 2) {
                        change = true;
                    }
                    if (!change || world.func_180495_p(p = new BlockPos(originPos.func_177958_n() + x, y, originPos.func_177952_p() + z)).func_177230_c() == b) continue;
                    world.func_180501_a(p, b.func_176223_P(), 3);
                }
            }
        }
    }

    public void destroyLootBox(World world, BlockPos originPos) {
        for (int y = 255; y >= 251; --y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos p = new BlockPos(originPos.func_177958_n() + x, y, originPos.func_177952_p() + z);
                    world.func_175698_g(p);
                }
            }
        }
    }

    private Entity spawnEntity(String mobName, World world, BlockPos blockPos, boolean createLootBox) {
        Entity entity = Woot.mobRegistry.createEntity(mobName, world);
        if (entity != null) {
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)blockPos.func_177958_n(), (float)blockPos.func_177956_o(), (float)blockPos.func_177952_p())) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(blockPos), null);
            }
            BlockPos originPos = new BlockPos(blockPos.func_177958_n(), 253, blockPos.func_177952_p());
            entity.func_70107_b((double)originPos.func_177958_n(), (double)originPos.func_177956_o(), (double)originPos.func_177952_p());
            if (createLootBox) {
                this.createLootBox(world, originPos);
            }
            ((EntityLivingBase)entity).field_70718_bc = 100;
        }
        return entity;
    }

    public void spawn(String mobName, EnumEnchantKey enchantKey, World world, BlockPos blockPos) {
        Entity entity = this.spawnEntity(mobName, world, blockPos, true);
        if (entity == null) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((WorldServer)world, enchantKey);
        if (fakePlayer == null) {
            return;
        }
        ((EntityLivingBase)entity).field_70717_bb = fakePlayer;
        ((EntityLivingBase)entity).func_70645_a(DamageSource.func_76365_a((EntityPlayer)fakePlayer));
    }

    int calcDeathXp(String mobName, SpawnerUpgrade upgrade) {
        if (upgrade == null) {
            return 0;
        }
        int base = Woot.mobRegistry.getDeathXp(mobName);
        if (upgrade.getUpgradeType() == EnumSpawnerUpgrade.XP_I) {
            return base;
        }
        float boost = upgrade.getXpBoost();
        int extra = (int)((float)base / 100.0f * boost);
        if (extra < 1) {
            extra = 1;
        }
        return base + extra;
    }

    void enchantItemStack(ItemStack itemStack, DifficultyInstance difficulty) {
        float f = difficulty.func_180170_c();
        boolean allowTreasure = false;
        EnchantmentHelper.func_77504_a((Random)Woot.RANDOM, (ItemStack)itemStack, (int)((int)(5.0f + f * (float)Woot.RANDOM.nextInt(18))), (boolean)allowTreasure);
    }

    boolean shouldEnchant(DifficultyInstance difficulty) {
        return Woot.RANDOM.nextFloat() < 0.25f * difficulty.func_180170_c();
    }

    public SpawnLoot getSpawnerLoot(String mobName, UpgradeSetup upgradeSetup, DifficultyInstance difficulty) {
        SpawnLoot spawnLoot = new SpawnLoot();
        int mobCount = Settings.baseMobCount;
        if (upgradeSetup.hasMassUpgrade()) {
            mobCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
        }
        SpawnerUpgrade xpUpgrade = null;
        if (Settings.allowXPGen && upgradeSetup.hasXpUpgrade()) {
            xpUpgrade = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getXpUpgrade());
        }
        for (int i = 0; i < mobCount; ++i) {
            ItemStack headStack;
            List<ItemStack> dropList = Woot.LOOT_TABLE_MANAGER.getDrops(mobName, upgradeSetup.getEnchantKey());
            if (!dropList.isEmpty()) {
                boolean shouldEnchant = this.shouldEnchant(difficulty);
                for (ItemStack stack : dropList) {
                    if (!stack.func_77948_v()) continue;
                    shouldEnchant = false;
                    stack.func_77978_p().func_82580_o("ench");
                    this.enchantItemStack(stack, difficulty);
                }
                if (shouldEnchant) {
                    for (ItemStack stack : dropList) {
                        if (!stack.func_77956_u()) continue;
                        this.enchantItemStack(stack, difficulty);
                        break;
                    }
                }
            }
            spawnLoot.drops.addAll(dropList);
            spawnLoot.xp += this.calcDeathXp(mobName, xpUpgrade);
            if (!upgradeSetup.hasDecapitateUpgrade() || (headStack = Woot.headRegistry.handleDecap(mobName, upgradeSetup.getDecapitateUpgrade())) == null) continue;
            spawnLoot.drops.add(headStack);
        }
        return spawnLoot;
    }

    public class SpawnLoot {
        List<ItemStack> drops = new ArrayList<ItemStack>();
        int xp = 0;

        public int getXp() {
            return this.xp;
        }

        public List<ItemStack> getDropList() {
            return this.drops;
        }
    }

    public static class SpawnReq {
        int totalRf;
        int spawnTime;
        int rfPerTick;

        public SpawnReq(int totalRf, int spawnTime) {
            this.totalRf = totalRf;
            this.spawnTime = spawnTime;
            this.rfPerTick = this.calcRfPerTick();
            this.totalRf = this.rfPerTick * this.spawnTime;
        }

        int calcRfPerTick() {
            if (this.spawnTime > 0) {
                float rfpertick = (float)this.totalRf / (float)this.spawnTime;
                return MathHelper.func_76123_f((float)rfpertick);
            }
            return 1;
        }

        public int getTotalRf() {
            return this.totalRf;
        }

        public int getSpawnTime() {
            return this.spawnTime;
        }

        public int getRfPerTick() {
            return this.rfPerTick;
        }

        public String toString() {
            return this.totalRf + "RF " + this.spawnTime + " ticks @ " + this.rfPerTick + "RF/tick";
        }
    }
}

