/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.woot.tileentity.TileEntityMobFactory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyManager
extends EnergyStorage {
    public static final int MAX_RF_TICK = Integer.MAX_VALUE;
    private TileEntityMobFactory factory;

    private EnergyManager(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public EnergyManager(int capacity, int maxReceive, TileEntityMobFactory factory) {
        super(capacity, maxReceive, 0);
        this.factory = factory;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.energy = compound.func_74762_e("Energy");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Energy", this.energy);
    }

    public boolean canExtract() {
        return super.canExtract();
    }

    public boolean canReceive() {
        return super.canReceive() && this.factory.isFormed();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.factory.isFormed() ? super.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int getEnergyStored() {
        return this.factory.isFormed() ? super.getEnergyStored() : 0;
    }

    public int getMaxEnergyStored() {
        return this.factory.isFormed() ? super.getMaxEnergyStored() : 0;
    }

    public int extractEnergyInternal(int amount) {
        int energyExtracted = Math.min(this.energy, Math.min(Integer.MAX_VALUE, amount));
        this.energy -= energyExtracted;
        return energyExtracted;
    }
}

