/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.event;

import ipsis.Woot;
import ipsis.woot.enchantment.EnchantmentDecapitate;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.reference.Settings;
import ipsis.woot.util.FakePlayerPool;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HandlerLivingDropsEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsEvent(LivingDropsEvent e) {
        if (e.getEntity() instanceof EntityLiving) {
            EnumEnchantKey key;
            String mobID;
            DamageSource damageSource = e.getSource();
            if (damageSource != null) {
                if (FakePlayerPool.isOurFakePlayer(damageSource.func_76364_f())) {
                    e.setCanceled(true);
                }
                mobID = Woot.mobRegistry.createWootName((EntityLiving)e.getEntity());
                key = EnumEnchantKey.getEnchantKey(e.getLootingLevel());
                Woot.LOOT_TABLE_MANAGER.update(mobID, key, e.getDrops(), true);
            } else if (!Settings.strictFactorySpawns) {
                if (e.getEntity() instanceof EntityMagmaCube ? ((EntityMagmaCube)e.getEntity()).func_189101_db() : e.getEntity() instanceof EntitySlime && ((EntitySlime)e.getEntity()).func_70809_q() != 1) {
                    return;
                }
                mobID = Woot.mobRegistry.createWootName((EntityLiving)e.getEntity());
                key = EnumEnchantKey.getEnchantKey(e.getLootingLevel());
                Woot.LOOT_TABLE_MANAGER.update(mobID, key, e.getDrops(), true);
            }
            if (damageSource != null && !e.isCanceled()) {
                if (!(e.getSource().func_76346_g() instanceof EntityPlayer)) {
                    return;
                }
                EntityPlayer player = (EntityPlayer)e.getSource().func_76346_g();
                ItemStack equipped = player.func_184614_ca();
                if (!EnchantmentDecapitate.hasEnchantmentDecapitate(equipped)) {
                    return;
                }
                EnchantmentDecapitate.handleLivingDrops(e);
            }
        }
    }
}

