/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.enchantment;

import ipsis.Woot;
import ipsis.woot.init.ModEnchantments;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class EnchantmentDecapitate
extends Enchantment {
    private static final String NAME = "woot_decapitate";
    private static final float DECAPITATE_CHANCE = 20.0f;

    public EnchantmentDecapitate() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(NAME);
        this.setRegistryName(NAME);
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 16;
    }

    public int func_77317_b(int enchantmentLevel) {
        return 60;
    }

    public static boolean hasEnchantmentDecapitate(ItemStack itemStack) {
        if (ModEnchantments.DECAPITATE != null) {
            return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.DECAPITATE, (ItemStack)itemStack) > 0;
        }
        return false;
    }

    private static EntityItem createEntityItem(World world, ItemStack itemStack, double x, double y, double z) {
        if (world == null || itemStack == null) {
            return null;
        }
        EntityItem entityItem = new EntityItem(world, x, y, z, itemStack);
        entityItem.func_174869_p();
        return entityItem;
    }

    private static boolean containsSkull(List<EntityItem> drops) {
        boolean found = false;
        for (EntityItem i : drops) {
            if (i == null || i.func_92059_d().func_77973_b() != Items.field_151144_bL) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean hasDecapitated() {
        return Woot.RANDOM.nextFloat() <= 0.2f;
    }

    public static void handleLivingDrops(LivingDropsEvent e) {
        if (e.getSource().func_76346_g() == null) {
            return;
        }
        if (EnchantmentDecapitate.hasDecapitated() && !EnchantmentDecapitate.containsSkull(e.getDrops())) {
            EntityItem entityItem;
            EntitySkeleton entitySkeleton;
            ItemStack itemStack = Woot.headRegistry.getVanillaHead((EntityLiving)e.getEntityLiving());
            if (e.getEntityLiving() instanceof EntityCreeper) {
                itemStack = new ItemStack(Items.field_151144_bL, 1, 4);
            } else if (e.getEntityLiving() instanceof EntityZombie) {
                itemStack = new ItemStack(Items.field_151144_bL, 1, 2);
            } else if (e.getEntityLiving() instanceof EntitySkeleton && (entitySkeleton = (EntitySkeleton)e.getEntityLiving()).func_189771_df() == SkeletonType.NORMAL) {
                itemStack = new ItemStack(Items.field_151144_bL, 1, 0);
            }
            if (e.getEntityLiving() instanceof EntitySkeleton && ((EntitySkeleton)e.getEntityLiving()).func_189771_df() == SkeletonType.WITHER) {
                itemStack = null;
            }
            if (itemStack != null && (entityItem = EnchantmentDecapitate.createEntityItem(e.getSource().func_76346_g().field_70170_p, itemStack, e.getEntityLiving().func_180425_c().func_177958_n(), e.getEntityLiving().func_180425_c().func_177956_o(), e.getEntityLiving().func_180425_c().func_177952_p())) != null) {
                e.getDrops().add(entityItem);
            }
        }
    }
}

