/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.manual;

import ipsis.woot.client.manual.BookPageCover;
import ipsis.woot.client.manual.BookPageText;
import ipsis.woot.client.manual.IBookPage;
import ipsis.woot.client.manual.Section;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.fml.common.Loader;

public class BookManager {
    public static BookManager INSTANCE = new BookManager();
    private ArrayList<String> sectionList = new ArrayList();
    private HashMap<String, Section> sectionMap = new HashMap();

    public void load() {
        this.addEntry("cover", new BookPageCover("cover.0"));
        this.addEntry("introduction", new BookPageText("introduction.0"), new BookPageText("introduction.1"));
        this.addEntry("crafting", new BookPageText("crafting.0"), new BookPageText("crafting.1"));
        this.addEntry("building", new BookPageText("building.0"), new BookPageText("building.1"), new BookPageText("building.2"), new BookPageText("building.3"));
        this.addEntry("capturing", new BookPageText("capturing.0"), new BookPageText("capturing.1"));
        this.addEntry("operation", new BookPageText("operation.0"), new BookPageText("operation.1"));
        this.addEntry("power", new BookPageText("power.0"));
        this.addEntry("tier1", new BookPageText("tier1.0"), new BookPageText("tier1.1"));
        this.addEntry("tier2", new BookPageText("tier2.0"), new BookPageText("tier2.1"));
        this.addEntry("tier3", new BookPageText("tier3.0"), new BookPageText("tier3.1"));
        this.addEntry("tier4", new BookPageText("tier4.0"), new BookPageText("tier4.1"));
        this.addEntry("proxy", new BookPageText("proxy.0"), new BookPageText("proxy.1"));
        this.addEntry("extrareq", new BookPageText("extrareq.0"), new BookPageText("extrareq.1"), new BookPageText("extrareq.2"));
        this.addEntry("upgrades", new BookPageText("upgrades.0"), new BookPageText("upgrades.1"));
        this.addEntry("upgrade_looting", new BookPageText("upgrade_looting.0"));
        this.addEntry("upgrade_rate", new BookPageText("upgrade_rate.0"));
        this.addEntry("upgrade_xp", new BookPageText("upgrade_xp.0"));
        this.addEntry("upgrade_mass", new BookPageText("upgrade_mass.0"));
        this.addEntry("upgrade_decapitate", new BookPageText("upgrade_decapitate.0"));
        this.addEntry("upgrade_efficiency", new BookPageText("upgrade_efficiency.0"));
        this.addEntry("enchant_decapitate", new BookPageText("enchant_decapitate.0"));
        if (Loader.isModLoaded((String)"BloodMagic")) {
            this.addEntry("upgrade_bloodmagic", new BookPageText("upgrade_bloodmagic.0"), new BookPageText("upgrade_bloodmagic.1"), new BookPageText("upgrade_bloodmagic.2"), new BookPageText("upgrade_bloodmagic.3"), new BookPageText("upgrade_bloodmagic.4"), new BookPageText("upgrade_bloodmagic.5"));
        }
        this.addEntry("blacklists", new BookPageText("blacklists.0"), new BookPageText("blacklists.1"));
        this.addEntry("dragon", new BookPageText("dragon.0"), new BookPageText("dragon.1"), new BookPageText("dragon.2"), new BookPageText("dragon.3"));
    }

    private void addEntry(String tag, IBookPage ... pages) {
        this.sectionList.add(tag);
        this.sectionMap.put(tag, new Section(tag, pages));
    }

    public IBookPage getFirstPage() {
        IBookPage firstPage = null;
        if (!this.sectionList.isEmpty()) {
            Section section = this.sectionMap.get(this.sectionList.get(0));
            firstPage = section.getFirstPage();
        }
        return firstPage;
    }

    public IBookPage getNextPage(IBookPage currPage) {
        IBookPage nextPage = currPage.getSection().getNextPage(currPage);
        if (nextPage == null) {
            Section section = currPage.getSection();
            for (int i = 0; i < this.sectionList.size() && nextPage == null; ++i) {
                if (!this.sectionList.get(i).equals(section.tag) || i >= this.sectionList.size() - 1) continue;
                nextPage = this.sectionMap.get(this.sectionList.get(i + 1)).getFirstPage();
            }
        }
        return nextPage;
    }

    public IBookPage getPrevPage(IBookPage currPage) {
        IBookPage prevPage = currPage.getSection().getPrevPage(currPage);
        if (prevPage == null) {
            Section section = currPage.getSection();
            for (int i = 0; i < this.sectionList.size() && prevPage == null; ++i) {
                if (!this.sectionList.get(i).equals(section.tag) || i == 0) continue;
                prevPage = this.sectionMap.get(this.sectionList.get(i - 1)).getLastPage();
            }
        }
        return prevPage;
    }

    public boolean hasNextPage(IBookPage currPage) {
        return this.getNextPage(currPage) != null;
    }

    public boolean hasPrevPage(IBookPage currPage) {
        return this.getPrevPage(currPage) != null;
    }
}

